/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import edu.colorado.phet.waveinterference.model.Lattice2D;
import edu.colorado.phet.waveinterference.model.WaveModel;
import edu.colorado.phet.waveinterference.view.AbstractWaveSideView;
import edu.colorado.phet.waveinterference.view.LatticeScreenCoordinates;
import edu.colorado.phet.waveinterference.view.WaveSampler;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class WaveSideView
extends AbstractWaveSideView {
    private PPath path;
    private Lattice2D lattice2D;
    private LatticeScreenCoordinates latticeScreenCoordinates;
    private double distBetweenPoints = 5.0;
    private double amplitudeScale = -83.33333333333333;
    private WaveSampler waveSampler;

    public WaveSideView(WaveModel waveModel, LatticeScreenCoordinates latticeScreenCoordinates) {
        this.lattice2D = waveModel.getLattice();
        this.latticeScreenCoordinates = latticeScreenCoordinates;
        this.path = new PPath();
        this.addChild(this.path);
        latticeScreenCoordinates.addListener(new LatticeScreenCoordinates.Listener(){

            public void mappingChanged() {
                WaveSideView.this.update();
            }
        });
        this.waveSampler = new WaveSampler(waveModel, -83.33333333333333, 5.0);
        this.update();
    }

    protected PPath getPath() {
        return this.path;
    }

    public void setStroke(Stroke stroke) {
        this.path.setStroke(stroke);
    }

    public void update() {
        this.setSpaceBetweenCells(this.latticeScreenCoordinates.getCellWidth());
        this.path.setPathTo(this.getWavePath());
    }

    protected GeneralPath getWavePath() {
        GeneralPath generalPath = new GeneralPath();
        Point2D[] point2DArray = this.readValues();
        if (point2DArray.length > 0) {
            generalPath.moveTo((float)point2DArray[0].getX(), (float)point2DArray[0].getY());
            for (int i = 1; i < point2DArray.length; ++i) {
                generalPath.lineTo((float)point2DArray[i].getX(), (float)point2DArray[i].getY());
            }
        }
        return generalPath;
    }

    protected Point2D[] readValues() {
        return this.waveSampler.readValues(this.getYValue());
    }

    public double getDistBetweenCells() {
        return this.distBetweenPoints;
    }

    public void setSpaceBetweenCells(double d) {
        this.distBetweenPoints = d;
        this.waveSampler.setDistanceBetweenCells(this.distBetweenPoints);
    }

    public void setStrokeColor(Color color) {
        this.path.setStrokePaint(color);
    }

    public int getYValue() {
        return this.latticeScreenCoordinates.getGridSize().height / 2;
    }
}

