/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import edu.colorado.phet.common.phetcommon.view.HorizontalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.ModelSlider;
import edu.colorado.phet.waveinterference.util.WIStrings;
import edu.colorado.phet.waveinterference.view.RotationWaveGraphic;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WaveRotateControl
extends HorizontalLayoutPanel {
    public WaveRotateControl(final RotationWaveGraphic rotationWaveGraphic) {
        final ModelSlider modelSlider = new ModelSlider(WIStrings.getString("controls.rotate-view"), WIStrings.getString("units.radians"), 0.0, 1.5707963267948966, rotationWaveGraphic.getRotation());
        modelSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                rotationWaveGraphic.setViewAngle(modelSlider.getValue());
            }
        });
        modelSlider.setPaintLabels(true);
        Hashtable<Double, JLabel> hashtable = new Hashtable<Double, JLabel>();
        hashtable.put(new Double(modelSlider.getMaximumModelValue()), new JLabel(WIStrings.getString("controls.side")));
        hashtable.put(new Double(modelSlider.getMinimumModelValue()), new JLabel(WIStrings.getString("controls.top")));
        modelSlider.setPaintTicks(false);
        modelSlider.setTextFieldVisible(false);
        modelSlider.setModelLabels(hashtable);
        modelSlider.getSlider().addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        double d = (modelSlider.getMaximumModelValue() + modelSlider.getMinimumModelValue()) / 2.0;
                        if (modelSlider.getValue() < d) {
                            modelSlider.setValue(modelSlider.getMinimumModelValue() + 0.1);
                            modelSlider.setValue(modelSlider.getMinimumModelValue());
                        } else {
                            modelSlider.setValue(modelSlider.getMaximumModelValue() - 0.1);
                            modelSlider.setValue(modelSlider.getMaximumModelValue());
                        }
                    }
                });
            }
        });
        modelSlider.getSlider().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                System.out.println("rotate.getSlider().getValueIsAdjusting() = " + modelSlider.getSlider().getValueIsAdjusting());
                if (!modelSlider.getSlider().getValueIsAdjusting()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            double d = (modelSlider.getMaximumModelValue() + modelSlider.getMinimumModelValue()) / 2.0;
                            if (modelSlider.getValue() < d) {
                                modelSlider.setValue(modelSlider.getMinimumModelValue());
                            } else {
                                modelSlider.setValue(modelSlider.getMaximumModelValue());
                            }
                        }
                    });
                }
            }
        });
        rotationWaveGraphic.addListener(new RotationWaveGraphic.Listener(){

            public void rotationChanged() {
                modelSlider.setValue(rotationWaveGraphic.getRotation());
            }
        });
        this.add(modelSlider);
    }
}

