/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import edu.colorado.phet.waveinterference.model.WaveModel;
import edu.colorado.phet.waveinterference.view.ColorGrid;
import edu.colorado.phet.waveinterference.view.ColorGridNode;
import edu.colorado.phet.waveinterference.view.ColorMap;
import edu.colorado.phet.waveinterference.view.LatticeScreenCoordinates;
import edu.colorado.phet.waveinterference.view.WaveGraphicCoordinates;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;

public class WaveModelGraphic
extends PNode {
    private ColorGridNode colorGridNode;
    private PPath borderGraphic;
    private ColorMap colorMap;
    private WaveModel waveModel;
    private LatticeScreenCoordinates latticeScreenCoordinates;
    private ArrayList listeners = new ArrayList();

    public WaveModelGraphic(WaveModel waveModel, int n, int n2, ColorMap colorMap) {
        this.waveModel = waveModel;
        this.colorGridNode = new ColorGridNode(new ColorGrid(n, n2, waveModel.getWidth(), waveModel.getHeight()));
        this.latticeScreenCoordinates = new WaveGraphicCoordinates(waveModel, this);
        this.addChild(this.colorGridNode);
        this.colorMap = colorMap;
        this.borderGraphic = new PPath(this.colorGridNode.getFullBounds());
        this.borderGraphic.setStroke(new BasicStroke(2.0f));
        this.borderGraphic.setStrokePaint(Color.darkGray);
        this.addChild(this.borderGraphic);
        this.addPropertyChangeListener("fullBounds", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                WaveModelGraphic.this.notifyMappingChanged();
            }
        });
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                WaveModelGraphic.this.borderGraphic.setPathTo(WaveModelGraphic.this.colorGridNode.getFullBounds());
                WaveModelGraphic.this.notifyMappingChanged();
            }
        };
        this.colorGridNode.addPropertyChangeListener("fullBounds", propertyChangeListener);
        this.colorGridNode.addPropertyChangeListener("bounds", propertyChangeListener);
        waveModel.addListener(new WaveModel.Listener(){

            public void sizeChanged() {
                WaveModelGraphic.this.update();
            }
        });
        this.update();
    }

    public LatticeScreenCoordinates getLatticeScreenCoordinates() {
        return this.latticeScreenCoordinates;
    }

    public void setColorMap(ColorMap colorMap) {
        this.colorMap = colorMap;
        this.update();
    }

    public void fullPaint(PPaintContext pPaintContext) {
        Graphics2D graphics2D = pPaintContext.getGraphics();
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Object object2 = graphics2D.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        super.fullPaint(pPaintContext);
        if (object == null) {
            object = RenderingHints.VALUE_ANTIALIAS_DEFAULT;
        }
        if (object2 == null) {
            object2 = RenderingHints.VALUE_INTERPOLATION_BICUBIC;
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object2);
    }

    public void update() {
        Dimension dimension = this.colorGridNode.getGridDimensions();
        this.colorGridNode.setGridDimensions(this.waveModel.getWidth(), this.waveModel.getHeight());
        this.colorGridNode.paint(this.colorMap);
        this.repaint();
        if (!dimension.equals(this.colorGridNode.getGridDimensions())) {
            this.notifyMappingChanged();
        }
        this.notifyColorChanged();
    }

    private void notifyColorChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.colorMapChanged();
        }
    }

    private void notifyMappingChanged() {
        this.latticeScreenCoordinates.notifyMappingChanged();
    }

    public void setCellDimensions(int n, int n2) {
        this.colorGridNode.setCellDimensions(n, n2);
        this.update();
        this.notifyMappingChanged();
    }

    public Dimension getCellDimensions() {
        return new Dimension(this.colorGridNode.getCellWidth(), this.colorGridNode.getCellHeight());
    }

    public ColorMap getColorMap() {
        return this.colorMap;
    }

    public WaveModel getWaveModel() {
        return this.waveModel;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public static interface Listener {
        public void colorMapChanged();
    }
}

