/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.piccolophet.nodes.MeasuringTape;
import edu.colorado.phet.waveinterference.view.LatticeScreenCoordinates;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class WaveMeasuringTape
extends MeasuringTape {
    private LatticeScreenCoordinates latticeScreenCoordinates;
    private Rectangle2D modelBounds = new Rectangle2D.Double(0.0, 0.0, 30.0, 30.0);

    public WaveMeasuringTape(LatticeScreenCoordinates latticeScreenCoordinates, double d, double d2) {
        super(new ModelViewTransform2D(new Rectangle(50, 50), new Rectangle(50, 50)), new Point2D.Double(), "cm");
        this.latticeScreenCoordinates = latticeScreenCoordinates;
        latticeScreenCoordinates.addListener(new LatticeScreenCoordinates.Listener(){

            public void mappingChanged() {
                WaveMeasuringTape.this.updateMapping();
            }
        });
        this.updateMapping();
        this.setWaveAreaSize(d, d2);
        Point2D.Double double_ = new Point2D.Double(d / 2.0, d2 / 2.0);
        Point2D.Double double_2 = new Point2D.Double(d * 0.75, d2 / 2.0);
        this.setLocation(double_, double_2);
        this.initialSrc = new Point2D.Double(double_.x, double_.y);
        this.initialDst = new Point2D.Double(double_2.x, double_2.y);
    }

    public void setWaveAreaSize(double d, double d2) {
        this.modelBounds = new Rectangle2D.Double(0.0, 0.0, d, d2);
    }

    private void updateMapping() {
        ModelViewTransform2D modelViewTransform2D = new ModelViewTransform2D(this.modelBounds, this.latticeScreenCoordinates.getScreenRect());
        super.setModelViewTransform2D(modelViewTransform2D);
    }
}

