/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import edu.colorado.phet.waveinterference.WaveInterferenceModelUnits;
import edu.colorado.phet.waveinterference.view.LatticeScreenCoordinates;
import java.awt.Dimension;
import java.text.DecimalFormat;
import java.util.Hashtable;
import javax.swing.JLabel;

public class WaveInterferenceScreenUnits {
    private WaveInterferenceModelUnits modelUnits;
    private LatticeScreenCoordinates latticeScreenCoordinates;

    public WaveInterferenceScreenUnits(WaveInterferenceModelUnits waveInterferenceModelUnits, LatticeScreenCoordinates latticeScreenCoordinates) {
        this.modelUnits = waveInterferenceModelUnits;
        this.latticeScreenCoordinates = latticeScreenCoordinates;
    }

    public String getDistanceUnits() {
        return this.modelUnits.getDistanceUnits();
    }

    public Dimension getGridSize() {
        return this.latticeScreenCoordinates.getGridSize();
    }

    double cellsToPhysicalX(int n) {
        return (double)n / (double)this.getGridSize().width * this.getPhysicalWidth();
    }

    private double getPhysicalWidth() {
        return this.modelUnits.getPhysicalWidth();
    }

    public Hashtable toHashtable(int[] nArray, double d) {
        Hashtable<Double, JLabel> hashtable = new Hashtable<Double, JLabel>();
        DecimalFormat decimalFormat = new DecimalFormat("#.#");
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            String string = decimalFormat.format(this.cellsToPhysicalX(n) * d);
            if (i == 0) {
                string = string + " " + this.getDistanceUnits();
            }
            hashtable.put(new Double(n), new JLabel(string));
        }
        return hashtable;
    }

    public Hashtable toHashtable(int[] nArray) {
        Hashtable<Double, JLabel> hashtable = new Hashtable<Double, JLabel>();
        DecimalFormat decimalFormat = new DecimalFormat("#.#");
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            String string = decimalFormat.format(this.cellsToPhysicalX(n));
            if (i == 0) {
                string = string + " " + this.getDistanceUnits();
            }
            hashtable.put(new Double(n), new JLabel(string));
        }
        return hashtable;
    }
}

