/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.waveinterference.model.WaveModel;
import edu.colorado.phet.waveinterference.view.LatticeScreenCoordinates;
import edu.umd.cs.piccolo.PNode;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.Point2D;

public class WaveGraphicCoordinates
extends LatticeScreenCoordinates {
    private PNode waveModelGraphic;
    private WaveModel waveModel;

    public WaveGraphicCoordinates(WaveModel waveModel, PNode pNode) {
        this.waveModel = waveModel;
        this.waveModelGraphic = pNode;
    }

    public Point2D toScreenCoordinates(int n, int n2) {
        Point point = new Point();
        Point point2 = new Point(100, 100);
        ModelViewTransform2D modelViewTransform2D = new ModelViewTransform2D(this.toLatticeCoordinatesFP(point), this.toLatticeCoordinatesFP(point2), point, point2);
        return modelViewTransform2D.modelToViewDouble(n, n2);
    }

    public Point2D toLatticeCoordinatesFP(Point2D point2D) {
        return this.toLatticeCoordinatesFP(point2D.getX(), point2D.getY());
    }

    private Point2D toLatticeCoordinatesFP(double d, double d2) {
        Point2D.Double double_ = new Point2D.Double(d, d2);
        this.waveModelGraphic.globalToLocal(double_);
        double d3 = ((Point2D)double_).getX() / this.waveModelGraphic.getFullBounds().getWidth();
        double d4 = ((Point2D)double_).getY() / this.waveModelGraphic.getFullBounds().getHeight();
        Point2D.Double double_2 = new Point2D.Double(d3, d4);
        return new Point2D.Double(((Point2D)double_2).getX() * (double)this.waveModel.getWidth(), ((Point2D)double_2).getY() * (double)this.waveModel.getHeight());
    }

    public Point toLatticeCoordinates(double d, double d2) {
        Point2D point2D = this.toLatticeCoordinatesFP(d, d2);
        return new Point((int)point2D.getX(), (int)point2D.getY());
    }

    protected Dimension getGridSize() {
        return new Dimension(this.waveModel.getWidth(), this.waveModel.getHeight());
    }
}

