/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.waveinterference.model.SlitPotential;
import edu.colorado.phet.waveinterference.view.LatticeScreenCoordinates;
import edu.colorado.phet.waveinterference.view.TopViewBarrierVisibility;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PDragEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class SlitPotentialGraphic
extends PhetPNode {
    private TopViewBarrierVisibility topViewBarrierVisibility;
    private SlitPotential slitPotential;
    private LatticeScreenCoordinates latticeScreenCoordinates;
    private PDragEventHandler horizontalDragHandler;
    public static final Color BARRIER_FILL = new Color(241, 216, 148);
    public static final Stroke BARRIER_STROKE = new BasicStroke(2.0f);
    public static final Paint BARRIER_STROKE_PAINT = Color.black;

    public SlitPotentialGraphic(SlitPotential slitPotential, LatticeScreenCoordinates latticeScreenCoordinates) {
        this(new TopViewBarrierVisibility(){

            public boolean isTopVisible() {
                return true;
            }
        }, slitPotential, latticeScreenCoordinates);
    }

    public SlitPotentialGraphic(TopViewBarrierVisibility topViewBarrierVisibility, final SlitPotential slitPotential, final LatticeScreenCoordinates latticeScreenCoordinates) {
        this.topViewBarrierVisibility = topViewBarrierVisibility;
        this.slitPotential = slitPotential;
        this.latticeScreenCoordinates = latticeScreenCoordinates;
        slitPotential.addListener(new SlitPotential.Listener(){

            public void slitsChanged() {
                SlitPotentialGraphic.this.update();
            }
        });
        this.update();
        latticeScreenCoordinates.addListener(new LatticeScreenCoordinates.Listener(){

            public void mappingChanged() {
                SlitPotentialGraphic.this.update();
            }
        });
        this.horizontalDragHandler = new PDragEventHandler(){
            private Point2D dragStartPt;
            int origLocation;

            protected void startDrag(PInputEvent pInputEvent) {
                super.startDrag(pInputEvent);
                this.dragStartPt = pInputEvent.getCanvasPosition();
                this.origLocation = slitPotential.getLocation();
            }

            protected void drag(PInputEvent pInputEvent) {
                Point2D point2D = pInputEvent.getCanvasPosition();
                double d = point2D.getX() - this.dragStartPt.getX();
                double d2 = latticeScreenCoordinates.toLatticeCoordinatesDifferentialX(d);
                slitPotential.setLocation((int)((double)this.origLocation + d2));
            }
        };
    }

    public void update() {
        this.removeAllChildren();
        if (this.topViewBarrierVisibility.isTopVisible()) {
            Rectangle[] rectangleArray = this.slitPotential.getBarrierRectangles();
            for (int i = 0; i < rectangleArray.length; ++i) {
                if (rectangleArray[i].isEmpty()) continue;
                PNode pNode = this.toShape(this.latticeScreenCoordinates.toScreenRect(rectangleArray[i]));
                PNode pNode2 = new PNode();
                pNode2.addChild(pNode);
                boolean[] blArray = this.getHandleEdges(i);
                for (int j = 0; j < blArray.length; ++j) {
                    PNode pNode3 = this.getEdgeDragHandle(pNode, blArray[j]);
                    pNode2.addChild(pNode3);
                }
                this.addChild(pNode2);
            }
        }
    }

    private boolean[] getHandleEdges(int n) {
        Rectangle[] rectangleArray = this.slitPotential.getBarrierRectangles();
        if (rectangleArray.length == 0 || rectangleArray.length == 1) {
            return new boolean[0];
        }
        if (rectangleArray.length == 2) {
            if (n == 0) {
                return new boolean[]{false};
            }
            return new boolean[]{true};
        }
        if (rectangleArray.length == 3) {
            if (n == 0) {
                return new boolean[]{false};
            }
            if (n == 1) {
                return new boolean[]{false, true};
            }
            if (n == 2) {
                return new boolean[]{true};
            }
        }
        return new boolean[0];
    }

    private PNode getEdgeDragHandle(PNode pNode, final boolean bl) {
        double d = bl ? pNode.getFullBounds().getMinY() : pNode.getFullBounds().getMaxY();
        Line2D.Double double_ = new Line2D.Double(pNode.getFullBounds().getX(), d, pNode.getFullBounds().getMaxX(), d);
        PhetPPath phetPPath = new PhetPPath(double_, (Stroke)new BasicStroke(5.0f), (Paint)new Color(0, 0, 0, 0));
        PDragEventHandler pDragEventHandler = new PDragEventHandler(){
            private Point2D dragStartPt;
            int origWidth;

            protected void startDrag(PInputEvent pInputEvent) {
                super.startDrag(pInputEvent);
                this.dragStartPt = pInputEvent.getCanvasPosition();
                this.origWidth = SlitPotentialGraphic.this.slitPotential.getSlitWidth();
            }

            protected void drag(PInputEvent pInputEvent) {
                Point2D point2D = pInputEvent.getCanvasPosition();
                double d = point2D.getY() - this.dragStartPt.getY();
                double d2 = SlitPotentialGraphic.this.latticeScreenCoordinates.toLatticeCoordinatesDifferentialY(d);
                double d3 = bl ? 1.0 : -1.0;
                SlitPotentialGraphic.this.slitPotential.setSlitWidth((int)((double)this.origWidth + d2 * 2.0 * d3));
            }
        };
        phetPPath.addInputEventListener(new CursorHandler(8));
        phetPPath.addInputEventListener(pDragEventHandler);
        return phetPPath;
    }

    public SlitPotential getSlitPotential() {
        return this.slitPotential;
    }

    public LatticeScreenCoordinates getLatticeScreenCoordinates() {
        return this.latticeScreenCoordinates;
    }

    public PNode toShape(Rectangle2D rectangle2D) {
        PPath pPath = new PPath(rectangle2D);
        pPath.setPaint(BARRIER_FILL);
        pPath.setStroke(BARRIER_STROKE);
        pPath.setStrokePaint(BARRIER_STROKE_PAINT);
        pPath.addInputEventListener(this.horizontalDragHandler);
        pPath.addInputEventListener(new CursorHandler());
        return pPath;
    }
}

