/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import edu.colorado.phet.common.phetcommon.view.HorizontalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.ModelSlider;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.waveinterference.WaveInterferenceModel;
import edu.colorado.phet.waveinterference.model.SlitPotential;
import edu.colorado.phet.waveinterference.util.WIStrings;
import edu.colorado.phet.waveinterference.view.VerticalLayoutPanelWithDisable;
import edu.colorado.phet.waveinterference.view.WaveInterferenceScreenUnits;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SlitControlPanel
extends VerticalLayoutPanelWithDisable {
    private SlitPotential slitPotential;
    private ModelSlider slitSeparation;
    private ModelSlider slitWidthSlider;
    private ModelSlider slitLocationSlider;
    private WaveInterferenceScreenUnits units;
    private WaveInterferenceModel model;
    private JCheckBox enableCheckBox;

    public SlitControlPanel(final SlitPotential slitPotential, WaveInterferenceScreenUnits waveInterferenceScreenUnits) {
        this.units = waveInterferenceScreenUnits;
        this.model = this.model;
        this.setBorder(BorderFactory.createEtchedBorder());
        this.slitPotential = slitPotential;
        HorizontalLayoutPanel horizontalLayoutPanel = new HorizontalLayoutPanel();
        this.enableCheckBox = new JCheckBox(WIStrings.getString("slit.enabled"), slitPotential.isEnabled());
        this.enableCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                slitPotential.setEnabled(SlitControlPanel.this.enableCheckBox.isSelected());
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        final JRadioButton jRadioButton = new JRadioButton(WIStrings.getString("controls.no-barrier"), !slitPotential.isEnabled());
        final JRadioButton jRadioButton2 = new JRadioButton(WIStrings.getString("slit.one"), slitPotential.isOneSlit() && slitPotential.isEnabled());
        final JRadioButton jRadioButton3 = new JRadioButton(WIStrings.getString("slit.two"), slitPotential.isTwoSlits() && slitPotential.isEnabled());
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
        jRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SlitControlPanel.this.updateUIToReflectSlitEnabled(!jRadioButton.isSelected());
            }
        });
        jRadioButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SlitControlPanel.this.updateUIToReflectSlitEnabled(true);
                slitPotential.setOneSlit();
                SlitControlPanel.this.updateSeparationCheckbox();
            }
        });
        jRadioButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SlitControlPanel.this.updateUIToReflectSlitEnabled(true);
                slitPotential.setTwoSlits();
                SlitControlPanel.this.updateSeparationCheckbox();
            }
        });
        VerticalLayoutPanel verticalLayoutPanel = new VerticalLayoutPanel();
        verticalLayoutPanel.add(jRadioButton);
        verticalLayoutPanel.add(jRadioButton2);
        verticalLayoutPanel.add(jRadioButton3);
        horizontalLayoutPanel.add(verticalLayoutPanel);
        this.add(horizontalLayoutPanel);
        this.slitWidthSlider = new ModelSlider(WIStrings.getString("slit.width"), "", 0.0, 30.0, slitPotential.getSlitWidth());
        this.slitWidthSlider.setModelLabels(this.toHashtable(new int[]{0, 15, 30}));
        this.slitWidthSlider.setTextFieldVisible(false);
        this.slitWidthSlider.setBorder(null);
        this.slitWidthSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                slitPotential.setSlitWidth((int)SlitControlPanel.this.slitWidthSlider.getValue());
            }
        });
        this.add(this.slitWidthSlider);
        this.slitLocationSlider = new ModelSlider(WIStrings.getString("controls.barrier-location"), "", 0.0, 75.0, slitPotential.getLocation());
        this.slitLocationSlider.setModelLabels(this.toHashtable(new int[]{0, 37, 75}));
        this.slitLocationSlider.setTextFieldVisible(false);
        this.slitLocationSlider.setBorder(null);
        this.slitLocationSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                slitPotential.setLocation((int)SlitControlPanel.this.slitLocationSlider.getValue());
            }
        });
        this.add(this.slitLocationSlider);
        this.slitSeparation = new ModelSlider(WIStrings.getString("slit.separation"), "", 0.0, 50.0, slitPotential.getSlitSeparation());
        this.slitSeparation.setModelLabels(this.toHashtable(new int[]{0, 25, 50}));
        this.slitSeparation.setTextFieldVisible(false);
        this.slitSeparation.setBorder(null);
        this.slitSeparation.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                slitPotential.setSlitSeparation((int)SlitControlPanel.this.slitSeparation.getValue());
            }
        });
        this.add(this.slitSeparation);
        this.updateSeparationCheckbox();
        this.updateUIToReflectSlitEnabled(slitPotential.isEnabled());
        slitPotential.addListener(new SlitPotential.Listener(){

            public void slitsChanged() {
                SlitControlPanel.this.slitSeparation.setValue(slitPotential.getSlitSeparation());
                SlitControlPanel.this.slitWidthSlider.setValue(slitPotential.getSlitWidth());
                SlitControlPanel.this.slitLocationSlider.setValue(slitPotential.getLocation());
                SlitControlPanel.this.enableCheckBox.setSelected(slitPotential.isEnabled());
                if (!slitPotential.isEnabled()) {
                    jRadioButton.setSelected(true);
                } else if (slitPotential.isOneSlit()) {
                    jRadioButton2.setSelected(true);
                } else {
                    jRadioButton3.setSelected(true);
                }
                SlitControlPanel.this.updateUIToReflectSlitEnabled(slitPotential.isEnabled());
            }
        });
        this.setFillNone();
    }

    private Hashtable toHashtable(int[] nArray) {
        return this.units.toHashtable(nArray);
    }

    private void updateSeparationCheckbox() {
        boolean bl = !this.slitPotential.isOneSlit();
        boolean bl2 = this.slitPotential.isEnabled();
        boolean bl3 = this.getEnabledFlag();
        this.slitSeparation.setEnabled(bl && bl2 && bl3);
    }

    private void updateUIToReflectSlitEnabled(boolean bl) {
        this.slitPotential.setEnabled(bl);
        this.slitWidthSlider.setEnabled(bl);
        this.slitLocationSlider.setEnabled(bl);
        this.updateSeparationCheckbox();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.updateUIToReflectSlitEnabled(this.slitPotential.isEnabled());
        this.updateSeparationCheckbox();
    }
}

