/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import edu.colorado.phet.common.jfreechartphet.piccolo.JFreeChartNode;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.waveinterference.model.WaveModel;
import edu.colorado.phet.waveinterference.util.WIStrings;
import edu.colorado.phet.waveinterference.view.BrightnessScreenGraphic;
import edu.colorado.phet.waveinterference.view.ColorVector;
import edu.colorado.phet.waveinterference.view.LatticeScreenCoordinates;
import edu.colorado.phet.waveinterference.view.MutableColor;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class ScreenChartGraphic
extends PhetPNode {
    private LatticeScreenCoordinates latticeScreenCoordinates;
    private WaveModel waveModel;
    private MutableColor strokeColor;
    private BrightnessScreenGraphic brightnessScreenGraphic;
    private JFreeChart jFreeChart;
    private JFreeChartNode jFreeChartNode;
    private PPath path;

    public ScreenChartGraphic(String string, LatticeScreenCoordinates latticeScreenCoordinates, WaveModel waveModel, MutableColor mutableColor, BrightnessScreenGraphic brightnessScreenGraphic) {
        this.latticeScreenCoordinates = latticeScreenCoordinates;
        this.waveModel = waveModel;
        this.strokeColor = mutableColor;
        this.brightnessScreenGraphic = brightnessScreenGraphic;
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"0"));
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection(xYSeries);
        this.jFreeChart = ChartFactory.createXYLineChart(string, WIStrings.getString("readout.intensity").toLowerCase(), WIStrings.getString("readout.position"), xYSeriesCollection, PlotOrientation.VERTICAL, false, false, false);
        this.jFreeChart.getXYPlot().getDomainAxis().setRange(0.0, 1.0);
        this.jFreeChartNode = new JFreeChartNode(this.jFreeChart, true);
        this.jFreeChartNode.setBounds(0.0, 0.0, 150.0, 300.0);
        this.jFreeChartNode.updateChartRenderingInfo();
        this.path = new PPath();
        this.path.setStroke(new BasicStroke(3.0f));
        this.path.setStrokePaint(Color.blue);
        this.addChild(this.jFreeChartNode);
        this.addChild(this.path);
        latticeScreenCoordinates.addListener(new LatticeScreenCoordinates.Listener(){

            public void mappingChanged() {
                ScreenChartGraphic.this.updateLocation();
            }
        });
        this.updateLocation();
        mutableColor.addListener(new MutableColor.Listener(){

            public void colorChanged() {
                ScreenChartGraphic.this.updateColor();
            }
        });
        this.updateColor();
    }

    private void updateLocation() {
        this.synchronizeHeight();
        this.synchronizeHeight();
        PBounds pBounds = this.jFreeChartNode.getBounds();
        Rectangle2D rectangle2D = this.jFreeChartNode.getDataArea();
        double d = this.latticeScreenCoordinates.toScreenCoordinates(this.waveModel.getWidth() - 1, 0).getX();
        double d2 = this.latticeScreenCoordinates.toScreenCoordinates(0, 0).getY();
        double d3 = rectangle2D.getY() - ((RectangularShape)pBounds).getY();
        double d4 = rectangle2D.getX() - ((RectangularShape)pBounds).getX();
        this.jFreeChartNode.setBounds(0.0, 0.0, ((RectangularShape)pBounds).getWidth(), ((RectangularShape)pBounds).getHeight());
        this.jFreeChartNode.setOffset(this.brightnessScreenGraphic.getFullBounds().getMaxX() + 2.0, d2 - d3);
    }

    private void synchronizeHeight() {
        double d = this.getDesiredDataHeight() - this.getActualDataHeight();
        this.changeDataHeight((int)d);
    }

    private void changeDataHeight(int n) {
        PBounds pBounds = this.jFreeChartNode.getBounds();
        this.jFreeChartNode.setBounds(((RectangularShape)pBounds).getX(), ((RectangularShape)pBounds).getY(), ((RectangularShape)pBounds).getWidth(), ((RectangularShape)pBounds).getHeight() + (double)n);
        this.jFreeChartNode.updateChartRenderingInfo();
    }

    private double getActualDataHeight() {
        return this.jFreeChartNode.getDataArea().getHeight();
    }

    private double getDesiredDataHeight() {
        Point2D point2D = this.latticeScreenCoordinates.toScreenCoordinates(0, 0);
        Point2D point2D2 = this.latticeScreenCoordinates.toScreenCoordinates(this.waveModel.getWidth() - 1, this.waveModel.getHeight() - 1);
        return point2D2.getY() - point2D.getY();
    }

    public void updateChart() {
        GeneralPath generalPath = new GeneralPath();
        this.fillPath2(generalPath);
        this.path.setPathTo(generalPath);
        Point2D point2D = this.jFreeChartNode.plotToNode(new Point2D.Double(0.0, this.jFreeChart.getXYPlot().getRangeAxis().getRange().getUpperBound()));
        this.jFreeChartNode.localToParent(point2D);
        this.path.setOffset(new Point2D.Double(point2D.getX(), point2D.getY()));
    }

    private double colorToMagnitude(Color color) {
        return new ColorVector(color).getMagnitude() * 80.0;
    }

    private void fillPath2(GeneralPath generalPath) {
        generalPath.moveTo((float)this.colorToMagnitude(this.brightnessScreenGraphic.getColor(0)), (float)(this.latticeScreenCoordinates.getCellWidth() * 0.0));
        for (int i = 1; i < this.waveModel.getHeight(); ++i) {
            generalPath.lineTo((float)this.colorToMagnitude(this.brightnessScreenGraphic.getColor(i)), (float)(this.latticeScreenCoordinates.getCellWidth() * (double)i));
        }
    }

    public void setCurveColor(Color color) {
        this.path.setStrokePaint(color);
    }

    private void updateColor() {
        this.setCurveColor(this.strokeColor.getColor());
    }

    public Rectangle2D getChartBounds() {
        PBounds pBounds = this.jFreeChartNode.getFullBounds();
        this.localToParent(pBounds);
        return pBounds;
    }
}

