/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import edu.colorado.phet.waveinterference.view.AbstractWaveSideView;
import edu.colorado.phet.waveinterference.view.LatticeScreenCoordinates;
import edu.colorado.phet.waveinterference.view.RotationGlyph;
import edu.colorado.phet.waveinterference.view.WaveModelGraphic;
import edu.umd.cs.piccolo.PNode;
import java.util.ArrayList;

public class RotationWaveGraphic
extends PNode {
    private double rotation;
    private RotationGlyph rotationGlyph;
    private WaveModelGraphic waveModelGraphic;
    private PNode topView;
    private AbstractWaveSideView waveSideView;
    private ArrayList listeners = new ArrayList();

    public RotationWaveGraphic(WaveModelGraphic waveModelGraphic, AbstractWaveSideView abstractWaveSideView, RotationGlyph rotationGlyph) {
        this(waveModelGraphic, waveModelGraphic, abstractWaveSideView, rotationGlyph);
    }

    public RotationWaveGraphic(WaveModelGraphic waveModelGraphic, PNode pNode, AbstractWaveSideView abstractWaveSideView, RotationGlyph rotationGlyph) {
        this(waveModelGraphic, pNode, abstractWaveSideView, rotationGlyph, 0.0);
    }

    public RotationWaveGraphic(WaveModelGraphic waveModelGraphic, PNode pNode, AbstractWaveSideView abstractWaveSideView, RotationGlyph rotationGlyph, double d) {
        this.waveModelGraphic = waveModelGraphic;
        this.topView = pNode;
        this.waveSideView = abstractWaveSideView;
        this.rotationGlyph = rotationGlyph;
        this.rotation = d;
        this.addChild(rotationGlyph);
        this.addChild(this.topView);
        this.addChild(this.waveSideView);
        this.setViewAngle(0.0);
        this.waveSideView.setSpaceBetweenCells(this.waveModelGraphic.getCellDimensions().width);
        this.updateLocations();
        this.updateGraphics();
    }

    public double getRotation() {
        return this.rotation;
    }

    private void updateRotationGlyph(double d) {
        this.rotationGlyph.setPrimaryHeight(this.waveModelGraphic.getFullBounds().getHeight());
        this.rotationGlyph.setPrimaryWidth(this.waveModelGraphic.getFullBounds().getWidth());
        this.rotationGlyph.setAngle(d);
        this.rotationGlyph.setOffset(0.0, this.waveModelGraphic.getFullBounds().getCenterY() - this.rotationGlyph.getSurfaceHeight());
    }

    public void updateLocations() {
        this.waveSideView.setOffset(this.waveModelGraphic.getFullBounds().getX(), this.waveModelGraphic.getFullBounds().getCenterY());
    }

    public void setViewAngle(double d) {
        if (this.rotation != d) {
            this.rotation = d;
            this.updateGraphics();
            for (int i = 0; i < this.listeners.size(); ++i) {
                Listener listener = (Listener)this.listeners.get(i);
                listener.rotationChanged();
            }
        }
    }

    public boolean isTopView() {
        return this.rotation == 0.0;
    }

    public boolean isSideView() {
        return this.rotation >= 1.5507963267948965;
    }

    protected void updateGraphics() {
        this.updateRotationGlyph(this.rotation);
        if (this.isTopView()) {
            this.showTopView();
        } else if (this.isSideView()) {
            this.showSideView();
        } else {
            this.showRotationGlyph();
        }
    }

    protected void showRotationGlyph() {
        this.setVisibility(true, false, false);
    }

    protected void showSideView() {
        this.setVisibility(false, true, false);
    }

    protected void showTopView() {
        this.setVisibility(false, false, true);
    }

    protected void setVisibility(boolean bl, boolean bl2, boolean bl3) {
        this.rotationGlyph.setVisible(bl);
        this.waveSideView.setVisible(bl2);
        this.topView.setVisible(bl3);
    }

    public void update() {
        this.waveSideView.update();
        this.waveModelGraphic.update();
        this.updateLocations();
    }

    public LatticeScreenCoordinates getLatticeScreenCoordinates() {
        return this.waveModelGraphic.getLatticeScreenCoordinates();
    }

    public void setCellSize(int n) {
        this.waveModelGraphic.setCellDimensions(n, n);
    }

    public void reset() {
        this.setViewAngle(0.0);
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public static interface Listener {
        public void rotationChanged();
    }
}

