/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.waveinterference.view.CrossSectionGraphic;
import edu.colorado.phet.waveinterference.view.MutableColor;
import edu.colorado.phet.waveinterference.view.WaveModelGraphic;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;

public class RotationGlyph
extends PNode {
    private PPath surface;
    private double angle;
    private double primaryHeight = 100.0;
    private double primaryWidth = 100.0;
    private double expansionWidth = 50.0;
    private PPath depth;
    private double boxHeight = 200.0;
    private MutableColor sideColor;
    private MutableColor surfaceColor = new MutableColor(Color.blue);
    private PPath crossSectionGraphic;
    private BasicStroke STROKE = new BasicStroke(3.0f, 1, 0, 1.0f);
    private ArrayList listeners = new ArrayList();

    public RotationGlyph() {
        this(new MutableColor(Color.blue));
    }

    public RotationGlyph(MutableColor mutableColor) {
        this.sideColor = mutableColor;
        this.surface = new PPath();
        this.crossSectionGraphic = new PPath();
        this.crossSectionGraphic.setPaint(Color.black);
        this.crossSectionGraphic.setStroke(CrossSectionGraphic.STROKE);
        this.surface.setPaint(this.sideColor.getColor());
        this.surface.setStroke(this.STROKE);
        this.depth = new PPath();
        this.depth.setPaint(Color.blue);
        this.depth.setStroke(this.STROKE);
        this.addChild(this.depth);
        this.addChild(this.surface);
        this.update();
        this.setRotation(0.0);
        this.sideColor.addListener(new MutableColor.Listener(){

            public void colorChanged() {
                RotationGlyph.this.updateColors();
            }
        });
        this.setSideColor(this.sideColor.getColor());
        this.updateColors();
    }

    private void updateColors() {
        this.surface.setPaint(this.surfaceColor.getColor());
        this.depth.setPaint(this.sideColor.getColor());
    }

    public void setPrimaryHeight(double d) {
        this.primaryHeight = d;
        this.update();
    }

    public void setPrimaryWidth(double d) {
        this.primaryWidth = d;
        this.update();
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void notifyAngleChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.angleChanged();
        }
    }

    public void setAngle(double d) {
        this.angle = d;
        assert (d >= 0.0 && d <= Math.PI);
        this.update();
        this.notifyAngleChanged();
    }

    public void update() {
        Function.LinearFunction linearFunction = new Function.LinearFunction(0.0, 1.5707963267948966, 1.0, 0.0);
        Function.LinearFunction linearFunction2 = new Function.LinearFunction(0.0, 1.5707963267948966, 0.0, 1.0);
        Function.LinearFunction linearFunction3 = new Function.LinearFunction(0.0, 1.5707963267948966, 0.0, this.expansionWidth);
        double d = 30.0;
        Function.LinearFunction linearFunction4 = new Function.LinearFunction(0.0, 1.5707963267948966, d, 0.0);
        double d2 = linearFunction3.evaluate(this.angle);
        double d3 = this.primaryHeight * linearFunction.evaluate(this.angle) / 2.0;
        double d4 = this.boxHeight * linearFunction2.evaluate(this.angle);
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath(d2, 0.0);
        doubleGeneralPath.lineToRelative(this.primaryWidth - 2.0 * d2, 0.0);
        doubleGeneralPath.lineToRelative(d2, d3);
        Point2D point2D = doubleGeneralPath.getCurrentPoint();
        doubleGeneralPath.lineToRelative(-this.primaryWidth, 0.0);
        Point2D point2D2 = doubleGeneralPath.getCurrentPoint();
        doubleGeneralPath.closePath();
        this.surface.setPathTo(doubleGeneralPath.getGeneralPath());
        double d5 = linearFunction4.evaluate(this.angle);
        DoubleGeneralPath doubleGeneralPath2 = new DoubleGeneralPath(point2D);
        doubleGeneralPath2.lineToRelative(-d5, d4);
        doubleGeneralPath2.lineToRelative(point2D2.getX() - point2D.getX() + 2.0 * d5, 0.0);
        doubleGeneralPath2.lineTo(point2D2);
        doubleGeneralPath2.closePath();
        this.depth.setPathTo(doubleGeneralPath2.getGeneralPath());
        this.crossSectionGraphic.setPathTo(new Line2D.Double(0.0, 2.0 * d3, this.primaryWidth, 2.0 * d3));
    }

    public double getSurfaceHeight() {
        return this.surface.getFullBounds().getHeight();
    }

    public double getAngle() {
        return this.angle;
    }

    public void setColors(Color color, Color color2) {
        this.sideColor.setColor(color);
        this.surfaceColor.setColor(color2);
        this.updateColors();
    }

    public void setSideColor(Color color) {
        this.sideColor.setColor(color);
        this.surfaceColor.setColor(color.darker());
        this.updateColors();
    }

    public void setTopColor(Color color) {
        this.sideColor.setColor(color.darker());
        this.surfaceColor.setColor(color);
        this.updateColors();
    }

    public void synchronizeDepthSize(final WaveModelGraphic waveModelGraphic) {
        waveModelGraphic.addPropertyChangeListener("fullBounds", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                RotationGlyph.this.updateBoxHeight(waveModelGraphic);
            }
        });
        this.updateBoxHeight(waveModelGraphic);
        this.update();
    }

    private void updateBoxHeight(WaveModelGraphic waveModelGraphic) {
        this.boxHeight = waveModelGraphic.getFullBounds().getHeight() / 2.0;
    }

    public static interface Listener {
        public void angleChanged();
    }
}

