/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.waveinterference.model.Lattice2D;
import edu.colorado.phet.waveinterference.model.SlitPotential;
import edu.colorado.phet.waveinterference.view.LatticeScreenCoordinates;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Point;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;

public class PressureWaveGraphic
extends PNode {
    private Lattice2D lattice;
    private LatticeScreenCoordinates latticeScreenCoordinates;
    private SlitPotential slitPotential;
    private BufferedImage blueImageORIG;
    private int spacingBetweenCells = 10;
    private ArrayList particles = new ArrayList();
    private BufferedImage pinkImageORIG;
    private BufferedImage blueImage;
    private BufferedImage pinkImage;
    private double acceleration = 0.3;
    private double maxVelocity = 3.0;
    private double friction = 0.97;
    private boolean pinked = false;
    private PPath background;
    private ArrayList listeners = new ArrayList();
    private double dx;
    private double dy;
    private boolean markersVisible = true;
    private Random random = new Random();

    public PressureWaveGraphic(Lattice2D lattice2D, LatticeScreenCoordinates latticeScreenCoordinates, SlitPotential slitPotential) {
        this.lattice = lattice2D;
        this.latticeScreenCoordinates = latticeScreenCoordinates;
        this.slitPotential = slitPotential;
        this.background = new PPath();
        this.background.setPaint(Color.black);
        this.background.setStrokePaint(Color.gray);
        this.addChild(this.background);
        try {
            this.blueImageORIG = ImageLoader.loadBufferedImage("wave-interference/images/particle-blue.gif");
            this.pinkImageORIG = ImageLoader.loadBufferedImage("wave-interference/images/particle-pink.gif");
            this.blueImage = BufferedImageUtils.rescaleYMaintainAspectRatio(this.blueImageORIG, 14);
            this.pinkImage = BufferedImageUtils.rescaleYMaintainAspectRatio(this.pinkImageORIG, 14);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        int n = 3;
        for (int i = 0; i < lattice2D.getWidth(); ++i) {
            for (int j = 0; j < lattice2D.getHeight(); ++j) {
                if (i % n != 0 || j % n != 0) continue;
                Particle particle = this.isMarked(i, j) ? new MarkedParticle(this.blueImage, i, j) : new Particle(this.blueImage, i, j);
                this.addParticle(particle);
            }
        }
        latticeScreenCoordinates.addListener(new LatticeScreenCoordinates.Listener(){

            public void mappingChanged() {
                PressureWaveGraphic.this.updateBounds();
            }
        });
        this.updateBounds();
        this.reorderChildren();
        slitPotential.addListener(new SlitPotential.Listener(){

            public void slitsChanged() {
                PressureWaveGraphic.this.doSlitsChanged();
            }
        });
        this.doSlitsChanged();
    }

    private void doSlitsChanged() {
        for (int i = 0; i < this.particles.size(); ++i) {
            Particle particle = (Particle)this.particles.get(i);
            if (this.barrierCoversParticle(particle)) {
                particle.setVisible(false);
                continue;
            }
            particle.setVisible(true);
        }
    }

    private boolean barrierCoversParticle(Particle particle) {
        Point point = particle.getHome();
        double d = this.slitPotential.getPotential(point.x, point.y, 0);
        return d != 0.0;
    }

    private boolean isMarked(int n, int n2) {
        return this.random.nextDouble() < 0.05;
    }

    private void updateBounds() {
        Point2D point2D = this.latticeScreenCoordinates.toScreenCoordinates(0, 0);
        this.setOffset(point2D.getX() + this.dx, point2D.getY() + this.dy);
        int n = (int)this.latticeScreenCoordinates.getCellWidth();
        this.setSpaceBetweenCells(n);
        this.background.setPathTo(new Rectangle2D.Double(0.0, 0.0, this.latticeScreenCoordinates.getScreenRect().getWidth(), this.latticeScreenCoordinates.getScreenRect().getHeight()));
    }

    private void reorderChildren() {
        Particle particle;
        int n;
        ArrayList arrayList = new ArrayList(this.particles);
        super.removeAllChildren();
        this.addChild(this.background);
        Collections.shuffle(arrayList);
        for (n = 0; n < arrayList.size(); ++n) {
            particle = (Particle)arrayList.get(n);
            this.addChild(particle);
        }
        for (n = 0; n < this.particles.size(); ++n) {
            particle = (Particle)this.particles.get(n);
            if (!(particle instanceof MarkedParticle)) continue;
            this.removeChild(particle);
            this.addChild(particle);
        }
    }

    public void setParticleImageSize(int n) {
        BufferedImage bufferedImage = BufferedImageUtils.rescaleYMaintainAspectRatio(this.blueImageORIG, n);
        BufferedImage bufferedImage2 = BufferedImageUtils.rescaleYMaintainAspectRatio(this.pinkImageORIG, n);
        for (int i = 0; i < this.particles.size(); ++i) {
            Particle particle = (Particle)this.particles.get(i);
            if (particle.getImage() == this.blueImage) {
                particle.setImage(bufferedImage);
                continue;
            }
            particle.setImage(bufferedImage2);
        }
        this.pinkImage = bufferedImage2;
        this.blueImage = bufferedImage;
    }

    public double getImageSize() {
        return this.pinkImage.getHeight();
    }

    private void addParticle(Particle particle) {
        this.particles.add(particle);
        this.addChild(particle);
    }

    public void setSpaceBetweenCells(int n) {
        this.spacingBetweenCells = n;
        this.update();
    }

    public double getDistBetweenCells() {
        return this.spacingBetweenCells;
    }

    public void setParticleAcceleration(double d) {
        this.acceleration = d;
    }

    public double getParticleAcceleration() {
        return this.acceleration;
    }

    public double getMaxVelocity() {
        return this.maxVelocity;
    }

    public void setMaxVelocity(double d) {
        this.maxVelocity = d;
    }

    public double getFriction() {
        return this.friction;
    }

    public void setFriction(double d) {
        this.friction = d;
    }

    public void setOffsetDX(double d, double d2) {
        this.dx = d;
        this.dy = d2;
        this.updateBounds();
    }

    public void reset() {
        Object object;
        int n;
        for (n = 0; n < this.particles.size(); ++n) {
            object = (Particle)this.particles.get(n);
            ((Particle)object).reset();
        }
        this.setMarkersVisible(true);
        for (n = 0; n < this.listeners.size(); ++n) {
            object = (Listener)this.listeners.get(n);
            object.markerVisibilityChanged();
        }
    }

    public boolean getMarkersVisible() {
        return this.markersVisible;
    }

    public void setMarkersVisible(boolean bl) {
        this.markersVisible = bl;
        for (int i = 0; i < this.particles.size(); ++i) {
            Particle particle = (Particle)this.particles.get(i);
            if (!(particle instanceof MarkedParticle)) continue;
            MarkedParticle markedParticle = (MarkedParticle)particle;
            markedParticle.updateMarkVisible();
        }
    }

    public void removeAllChildren() {
        super.removeAllChildren();
        this.particles.clear();
    }

    public void update() {
        for (int i = 0; i < this.particles.size(); ++i) {
            Particle particle = (Particle)this.particles.get(i);
            particle.update();
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public static interface Listener {
        public void markerVisibilityChanged();
    }

    public class MarkedParticle
    extends Particle {
        private PPath mark;

        public MarkedParticle(BufferedImage bufferedImage, int n, int n2) {
            super(bufferedImage, n, n2);
            PhetFont phetFont = new PhetFont(1, 22);
            FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), true, false);
            GlyphVector glyphVector = phetFont.createGlyphVector(fontRenderContext, "X");
            Shape shape = glyphVector.getOutline();
            this.mark = new PPath(shape);
            this.mark.setStroke(new BasicStroke(1.35f));
            this.mark.setStrokePaint(Color.red);
            this.addChild(this.mark);
            this.mark.setOffset((double)(this.getImage().getWidth(null) / 2) - this.mark.getFullBounds().getWidth() / 2.0, (double)(this.getImage().getHeight(null) / 2) + this.mark.getFullBounds().getHeight() / 2.0);
            this.updateMarkVisible();
        }

        public void updateMarkVisible() {
            this.mark.setVisible(PressureWaveGraphic.this.markersVisible);
        }
    }

    public class Particle
    extends PImage {
        private int homeX;
        private int homeY;
        private double a;
        private double b;
        private double speed;
        private Vector2D velocity;
        private BufferedImage newImage;

        public Particle(BufferedImage bufferedImage, int n, int n2) {
            super(bufferedImage);
            this.speed = 4.0;
            this.velocity = new Vector2D();
            this.newImage = bufferedImage;
            this.homeX = n;
            this.homeY = n2;
            this.a = n * PressureWaveGraphic.this.spacingBetweenCells;
            this.b = n2 * PressureWaveGraphic.this.spacingBetweenCells;
            this.update();
        }

        public Point getHome() {
            return new Point(this.homeX, this.homeY);
        }

        public void reset() {
            this.velocity.setComponents(0.0, 0.0);
            this.setOffset(this.homeX * PressureWaveGraphic.this.spacingBetweenCells, this.homeY * PressureWaveGraphic.this.spacingBetweenCells);
        }

        public void update() {
            SearchResult searchResult = this.searchForTarget();
            Point point = searchResult.getLocation();
            if (point != null) {
                double d = point.x * PressureWaveGraphic.this.spacingBetweenCells;
                double d2 = point.y * PressureWaveGraphic.this.spacingBetweenCells;
                Vector2D vector2D = new Vector2D(new Point2D.Double(this.a, this.b), new Point2D.Double(d, d2));
                double d3 = 1.0;
                double d4 = 1.0;
                if (Math.abs(searchResult.getPressure()) < 0.01) {
                    d = this.homeX * PressureWaveGraphic.this.spacingBetweenCells;
                    d2 = this.homeY * PressureWaveGraphic.this.spacingBetweenCells;
                    vector2D.rotate(PressureWaveGraphic.this.random.nextDouble() * Math.PI * 2.0);
                    d3 = 0.5;
                    d4 = 1.0 / PressureWaveGraphic.this.friction * 0.99;
                    vector2D = new Vector2D(new Point2D.Double(this.a, this.b), new Point2D.Double(d, d2));
                }
                this.accelerateToTarget(vector2D, d3, d4);
            }
        }

        private SearchResult searchForTarget() {
            return this.searchForMin();
        }

        private SearchResult searchForMin() {
            double d = Double.POSITIVE_INFINITY;
            int n = 8;
            Point point = null;
            for (int i = -n / 2; i <= n / 2; ++i) {
                for (int j = -n / 2; j <= n / 2; ++j) {
                    if (!this.inBounds(this.homeX + i, this.homeY + j)) continue;
                    if (point != null) {
                        if (!((double)PressureWaveGraphic.this.lattice.getValue(this.homeX + i, this.homeY + j) < d)) continue;
                        Point point2 = new Point(this.homeX + i, this.homeY + j);
                        if (!(point2.distance(this.homeX, this.homeY) <= (double)(n / 2))) continue;
                    }
                    point = new Point(this.homeX + i, this.homeY + j);
                    d = PressureWaveGraphic.this.lattice.getValue(this.homeX + i, this.homeY + j);
                }
            }
            return new SearchResult(d, point);
        }

        private void accelerateToTarget(Vector2D vector2D, double d, double d2) {
            if (vector2D.getMagnitude() >= 1.2) {
                vector2D.normalize();
                double d3 = PressureWaveGraphic.this.acceleration * d;
                vector2D.scale(d3);
                this.velocity = this.velocity.add(vector2D);
                if (this.velocity.getX() > PressureWaveGraphic.this.maxVelocity) {
                    this.velocity.setX(PressureWaveGraphic.this.maxVelocity);
                }
                if (this.velocity.getY() > PressureWaveGraphic.this.maxVelocity) {
                    this.velocity.setY(PressureWaveGraphic.this.maxVelocity);
                }
                if (this.velocity.getX() < -PressureWaveGraphic.this.maxVelocity) {
                    this.velocity.setX(-PressureWaveGraphic.this.maxVelocity);
                }
                if (this.velocity.getY() < -PressureWaveGraphic.this.maxVelocity) {
                    this.velocity.setY(-PressureWaveGraphic.this.maxVelocity);
                }
                this.velocity.scale(PressureWaveGraphic.this.friction * d2);
                Point2D.Double double_ = this.velocity.getDestination(new Point2D.Double(this.a, this.b));
                this.a = ((Point2D)double_).getX();
                this.b = ((Point2D)double_).getY();
                this.setOffset(this.a, this.b);
            }
        }

        private boolean inBounds(int n, int n2) {
            return n > 0 && n2 > 0 && n < PressureWaveGraphic.this.lattice.getWidth() && n2 < PressureWaveGraphic.this.lattice.getHeight();
        }

        class SearchResult {
            private double pressure;
            private Point location;

            public SearchResult(double d, Point point) {
                this.pressure = d;
                this.location = point;
            }

            public double getPressure() {
                return this.pressure;
            }

            public Point getLocation() {
                return this.location;
            }
        }
    }
}

