/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import edu.colorado.phet.common.phetcommon.view.ModelSlider;
import edu.colorado.phet.waveinterference.util.WIStrings;
import edu.colorado.phet.waveinterference.view.MultiOscillator;
import edu.colorado.phet.waveinterference.view.VerticalLayoutPanelWithDisable;
import edu.colorado.phet.waveinterference.view.WaveInterferenceScreenUnits;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MultiOscillatorControlPanel
extends VerticalLayoutPanelWithDisable {
    private MultiOscillator multiOscillator;
    private WaveInterferenceScreenUnits units;
    private ModelSlider spacingSlider;
    private JRadioButton oneDrip;
    private JRadioButton twoDrips;

    public MultiOscillatorControlPanel(final MultiOscillator multiOscillator, String string, String string2, WaveInterferenceScreenUnits waveInterferenceScreenUnits) {
        this.multiOscillator = multiOscillator;
        this.units = waveInterferenceScreenUnits;
        this.setBorder(BorderFactory.createEtchedBorder());
        this.oneDrip = new JRadioButton(string, multiOscillator.isOneSource());
        this.oneDrip.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                multiOscillator.setOneDrip();
                MultiOscillatorControlPanel.this.updateSpacingSlider();
            }
        });
        this.twoDrips = new JRadioButton(string2, multiOscillator.isTwoSource());
        this.twoDrips.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                multiOscillator.setTwoDrips();
                MultiOscillatorControlPanel.this.updateSpacingSlider();
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.oneDrip);
        buttonGroup.add(this.twoDrips);
        this.add(this.oneDrip);
        this.add(this.twoDrips);
        this.spacingSlider = new ModelSlider(WIStrings.getString("controls.spacing"), "units.meters", 0.0, 30.0, multiOscillator.getSpacing());
        this.spacingSlider.setModelLabels(waveInterferenceScreenUnits.toHashtable(new int[]{0, 15, 30}, 2.0));
        this.spacingSlider.setTextFieldVisible(false);
        this.spacingSlider.setBorder(null);
        this.spacingSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                multiOscillator.setSpacing(MultiOscillatorControlPanel.this.spacingSlider.getValue());
            }
        });
        this.add(this.spacingSlider);
        multiOscillator.addListener(new MultiOscillator.Listener(){

            public void multiOscillatorChanged() {
                MultiOscillatorControlPanel.this.spacingSlider.setValue(multiOscillator.getSpacing());
                MultiOscillatorControlPanel.this.oneDrip.setSelected(multiOscillator.isOneSource());
                MultiOscillatorControlPanel.this.twoDrips.setSelected(multiOscillator.isTwoSource());
                MultiOscillatorControlPanel.this.updateSpacingSlider();
            }
        });
        this.updateSpacingSlider();
    }

    private void updateSpacingSlider() {
        this.spacingSlider.setEnabled(this.multiOscillator.isTwoSource() && this.getEnabledFlag());
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.updateSpacingSlider();
    }
}

