/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.waveinterference.WaveInterferenceModel;
import edu.colorado.phet.waveinterference.view.LatticeScreenCoordinates;
import edu.colorado.phet.waveinterference.view.StopwatchPanelDecorator;
import edu.colorado.phet.waveinterference.view.WaveMeasuringTape;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PDragEventHandler;
import edu.umd.cs.piccolox.pswing.PSwing;
import edu.umd.cs.piccolox.pswing.PSwingCanvas;
import java.util.ArrayList;

public class MeasurementToolSet
extends PhetPNode {
    private WaveMeasuringTape measuringTape;
    private PNode stopwatchGraphic;
    private PSwingCanvas pSwingCanvas;
    private ArrayList listeners = new ArrayList();
    private StopwatchPanelDecorator stopwatchDecorator;
    private PSwing pswing;

    public MeasurementToolSet(PSwingCanvas pSwingCanvas, IClock iClock, LatticeScreenCoordinates latticeScreenCoordinates, WaveInterferenceModel waveInterferenceModel) {
        this(pSwingCanvas, iClock, latticeScreenCoordinates, waveInterferenceModel.getDistanceUnits(), waveInterferenceModel.getPhysicalWidth(), waveInterferenceModel.getPhysicalHeight(), waveInterferenceModel.getTimeUnits(), waveInterferenceModel.getTimeScale());
    }

    public MeasurementToolSet(PSwingCanvas pSwingCanvas, IClock iClock, LatticeScreenCoordinates latticeScreenCoordinates, String string, double d, double d2, String string2, double d3) {
        this.pSwingCanvas = pSwingCanvas;
        this.measuringTape = new WaveMeasuringTape(latticeScreenCoordinates, d, d2);
        this.measuringTape.setVisible(false);
        this.addChild(this.measuringTape);
        this.stopwatchDecorator = new StopwatchPanelDecorator(iClock, d3, string2);
        this.pswing = new PSwing(this.stopwatchDecorator);
        this.stopwatchGraphic = new PhetPNode(this.pswing);
        this.stopwatchGraphic.addInputEventListener(new CursorHandler(12));
        this.stopwatchGraphic.addInputEventListener(new PDragEventHandler());
        this.stopwatchGraphic.setVisible(false);
        this.setDistanceUnits(string);
        this.addChild(this.stopwatchGraphic);
        this.initStopwatchLocation();
    }

    public boolean isMeasuringTapeVisible() {
        return this.measuringTape.getVisible();
    }

    public void setMeasuringTapeVisible(boolean bl) {
        this.measuringTape.setVisible(bl);
        this.notifyVisibilityChanged();
    }

    public boolean isStopwatchVisible() {
        return this.stopwatchGraphic.getVisible();
    }

    public void setStopwatchVisible(boolean bl) {
        this.stopwatchGraphic.setVisible(bl);
        this.notifyVisibilityChanged();
    }

    public void setDistanceUnits(String string) {
        this.measuringTape.setUnits(string);
    }

    public void reset() {
        this.setMeasuringTapeVisible(false);
        this.setStopwatchVisible(false);
        this.measuringTape.reset();
        this.stopwatchDecorator.reset();
        this.initStopwatchLocation();
    }

    private void initStopwatchLocation() {
        this.pswing.setOffset(0.0, 0.0);
        this.stopwatchGraphic.setOffset(50.0, 50.0);
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void notifyVisibilityChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.toolVisibilitiesChanged();
        }
    }

    public static interface Listener {
        public void toolVisibilitiesChanged();
    }
}

