/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.waveinterference.util.WIStrings;
import edu.colorado.phet.waveinterference.view.LaserWaveChartGraphic;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.pswing.PSwing;
import edu.umd.cs.piccolox.pswing.PSwingCanvas;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;

public class LaserWaveChartControl
extends PNode {
    private LaserWaveChartGraphic laserWaveChartGraphic;
    private JCheckBox curve;
    private JCheckBox vectors;

    public LaserWaveChartControl(PSwingCanvas pSwingCanvas, final LaserWaveChartGraphic laserWaveChartGraphic) {
        this.laserWaveChartGraphic = laserWaveChartGraphic;
        this.curve = new JCheckBox(WIStrings.getString("light.curve"), laserWaveChartGraphic.isCurveVisible());
        this.curve.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                laserWaveChartGraphic.setCurveVisible(LaserWaveChartControl.this.curve.isSelected());
            }
        });
        this.vectors = new JCheckBox(WIStrings.getString("light.vectors"), laserWaveChartGraphic.isVectorsVisible());
        this.vectors.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                laserWaveChartGraphic.setVectorsVisible(LaserWaveChartControl.this.vectors.isSelected());
            }
        });
        VerticalLayoutPanel verticalLayoutPanel = new VerticalLayoutPanel();
        verticalLayoutPanel.add(this.curve);
        verticalLayoutPanel.add(this.vectors);
        PSwing pSwing = new PSwing(verticalLayoutPanel);
        this.addChild(pSwing);
        this.reset();
    }

    public void reset() {
        this.curve.setSelected(true);
        this.vectors.setSelected(false);
        this.laserWaveChartGraphic.setCurveVisible(this.curve.isSelected());
        this.laserWaveChartGraphic.setVectorsVisible(this.vectors.isSelected());
    }
}

