/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.waveinterference.model.WaveModel;
import edu.colorado.phet.waveinterference.view.IntensityReaderDecorator;
import edu.colorado.phet.waveinterference.view.LatticeScreenCoordinates;
import java.util.ArrayList;

public class IntensityReaderSet
extends PhetPNode {
    private ArrayList intensityReaders = new ArrayList();
    private boolean middle = false;

    public void addIntensityReader(String string, PhetPCanvas phetPCanvas, WaveModel waveModel, LatticeScreenCoordinates latticeScreenCoordinates, IClock iClock) {
        this.addIntensityReader(string, phetPCanvas, waveModel, latticeScreenCoordinates, 300.0, 300.0, iClock);
    }

    public void addIntensityReader(String string, PhetPCanvas phetPCanvas, WaveModel waveModel, LatticeScreenCoordinates latticeScreenCoordinates, double d, double d2, IClock iClock) {
        final IntensityReaderDecorator intensityReaderDecorator = new IntensityReaderDecorator(string, phetPCanvas, waveModel, latticeScreenCoordinates, iClock);
        intensityReaderDecorator.setConstrainedToMidline(this.middle);
        intensityReaderDecorator.addListener(new IntensityReaderDecorator.Listener(){

            public void deleted() {
                IntensityReaderSet.this.intensityReaders.remove(intensityReaderDecorator);
                IntensityReaderSet.this.removeChild(intensityReaderDecorator);
            }
        });
        intensityReaderDecorator.setOffset(d, d2);
        this.addChild(intensityReaderDecorator);
        this.intensityReaders.add(intensityReaderDecorator);
    }

    public void update() {
        for (int i = 0; i < this.intensityReaders.size(); ++i) {
            IntensityReaderDecorator intensityReaderDecorator = (IntensityReaderDecorator)this.intensityReaders.get(i);
            intensityReaderDecorator.update();
        }
    }

    public void setConstrainedToMidline(boolean bl) {
        this.middle = bl;
        for (int i = 0; i < this.intensityReaders.size(); ++i) {
            IntensityReaderDecorator intensityReaderDecorator = (IntensityReaderDecorator)this.intensityReaders.get(i);
            intensityReaderDecorator.setConstrainedToMidline(bl);
        }
    }

    public void reset() {
        while (this.intensityReaders.size() > 0) {
            IntensityReaderDecorator intensityReaderDecorator = (IntensityReaderDecorator)this.intensityReaders.get(0);
            intensityReaderDecorator.delete();
        }
    }
}

