/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.util.DefaultDecimalFormat;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetcommon.view.util.RectangleUtils;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.waveinterference.model.WaveModel;
import edu.colorado.phet.waveinterference.util.WIStrings;
import edu.colorado.phet.waveinterference.view.CrosshairConnection;
import edu.colorado.phet.waveinterference.view.LatticeScreenCoordinates;
import edu.colorado.phet.waveinterference.view.StripChartJFCNode;
import edu.umd.cs.piccolo.event.PDragEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Point;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class IntensityReader
extends PhetPNode {
    private WaveModel waveModel;
    private LatticeScreenCoordinates latticeScreenCoordinates;
    private IClock clock;
    private CrosshairGraphic crosshairGraphic;
    private TextReadout textReadout;
    private StripChartJFCNode stripChartJFCNode;
    private boolean detached = true;
    private Vector2D originalDisplacement;
    private boolean constrainedToMidline = false;
    private boolean allowAttachment = false;

    public IntensityReader(String string, WaveModel waveModel, LatticeScreenCoordinates latticeScreenCoordinates, IClock iClock) {
        this.waveModel = waveModel;
        this.latticeScreenCoordinates = latticeScreenCoordinates;
        this.clock = iClock;
        this.textReadout = new TextReadout();
        this.crosshairGraphic = new CrosshairGraphic(this, 10, 15);
        this.stripChartJFCNode = new StripChartJFCNode(175, 120, WIStrings.getString("readout.time"), string);
        CrosshairConnection crosshairConnection = new CrosshairConnection(this);
        this.addChild(this.textReadout);
        this.addChild(crosshairConnection);
        this.addChild(this.stripChartJFCNode);
        this.addChild(this.crosshairGraphic);
        this.stripChartJFCNode.addInputEventListener(new PairDragHandler());
        CursorHandler cursorHandler = new CursorHandler(12);
        this.addInputEventListener(cursorHandler);
        this.stripChartJFCNode.setOffset(-this.stripChartJFCNode.getFullBounds().getWidth() - this.crosshairGraphic.getFullBounds().getWidth() / 2.0, -this.stripChartJFCNode.getFullBounds().getHeight() / 2.0);
        this.textReadout.setOffset(0.0, this.crosshairGraphic.getFullBounds().getHeight());
        this.textReadout.setVisible(false);
        double d = this.crosshairGraphic.getFullBounds().getWidth() * 1.25;
        this.crosshairGraphic.translate(d, 0.0);
        this.originalDisplacement = this.getDisplacement();
        this.update();
    }

    private Vector2D getDisplacement() {
        return new Vector2D(this.stripChartJFCNode.getFullBounds().getCenter2D(), this.crosshairGraphic.getFullBounds().getCenter2D());
    }

    public void setConstrainedToMidline(boolean bl) {
        this.constrainedToMidline = bl;
        this.update();
    }

    public StripChartJFCNode getStripChartJFCNode() {
        return this.stripChartJFCNode;
    }

    public CrosshairGraphic getCrosshairGraphic() {
        return this.crosshairGraphic;
    }

    public void update() {
        Point2D point2D;
        if (this.constrainedToMidline) {
            point2D = new Point2D.Double(this.crosshairGraphic.getGlobalTranslation().getX(), this.latticeScreenCoordinates.getScreenRect().getY() + this.latticeScreenCoordinates.getScreenRect().getHeight() / 2.0);
            this.detachCrosshair();
            this.crosshairGraphic.setGlobalTranslation(point2D);
        }
        point2D = this.crosshairGraphic.getGlobalTranslation();
        point2D.setLocation(point2D.getX() + 1.0, point2D.getY() + 1.0);
        Point point = this.latticeScreenCoordinates.toLatticeCoordinates(point2D.getX(), point2D.getY());
        if (this.waveModel.containsLocation(point.x, point.y)) {
            double d = this.waveModel.getAverageValue(point.x, point.y, 1);
            this.textReadout.setText(WIStrings.getString("controls.magnitude") + new DefaultDecimalFormat("0.00").format(d));
            this.stripChartJFCNode.addValue(this.clock.getSimulationTime(), d);
        } else {
            this.textReadout.setText("");
            this.stripChartJFCNode.addValue(this.clock.getSimulationTime(), 0.0);
        }
        this.updateTextBackground();
    }

    private void updateTextBackground() {
        this.textReadout.updateBackground();
    }

    private void crosshairDropped(PInputEvent pInputEvent) {
        double d = 30.0;
        if (MathUtil.isApproxEqual(this.getDisplacement().getX(), this.originalDisplacement.getX(), d) && MathUtil.isApproxEqual(this.getDisplacement().getY(), this.originalDisplacement.getY(), d)) {
            this.attachCrosshair();
        }
    }

    private void attachCrosshair() {
        if (this.allowAttachment) {
            this.detached = false;
            this.crosshairGraphic.setOffset(this.stripChartJFCNode.getFullBounds().getCenterX() + this.originalDisplacement.getX() - this.crosshairGraphic.getFullBounds().getWidth() / 2.0, this.stripChartJFCNode.getFullBounds().getCenterY() + this.originalDisplacement.getY());
        }
    }

    private void detachCrosshair() {
        this.detached = true;
    }

    static class CrosshairGraphic
    extends PComposite {
        private static final Paint CROSSHAIR_COLOR = Color.white;
        private BasicStroke CROSSHAIR_STROKE = new BasicStroke(2.0f);
        private CrosshairDragHandler listener;
        private IntensityReader intensityReader;

        public CrosshairGraphic(IntensityReader intensityReader, int n, int n2) {
            this.intensityReader = intensityReader;
            Ellipse2D.Double double_ = new Ellipse2D.Double(-n, -n, n * 2, n * 2);
            PPath pPath = new PPath(double_);
            pPath.setStrokePaint(Color.red);
            pPath.setStroke(new BasicStroke(2.0f));
            PPath pPath2 = new PPath(new Line2D.Double(0.0, -n2, 0.0, n2));
            pPath2.setStroke(this.CROSSHAIR_STROKE);
            pPath2.setStrokePaint(CROSSHAIR_COLOR);
            PPath pPath3 = new PPath(new Line2D.Double(-n2, 0.0, n2, 0.0));
            pPath3.setStroke(this.CROSSHAIR_STROKE);
            pPath3.setStrokePaint(CROSSHAIR_COLOR);
            Area area = new Area();
            area.add(new Area(new Rectangle2D.Double(-n2, -n2, n2 * 2, n2 * 2)));
            area.subtract(new Area(double_));
            PPath pPath4 = new PPath(area);
            pPath4.setPaint(Color.lightGray);
            pPath4.setStrokePaint(Color.gray);
            this.addChild(pPath4);
            this.addChild(pPath);
            this.addChild(pPath2);
            this.addChild(pPath3);
            PPath pPath5 = new PPath(new Rectangle2D.Double(-n2, -n2, n2 * 2, n2 * 2));
            pPath5.setPaint(new Color(255, 255, 255, 0));
            pPath5.setStrokePaint(new Color(255, 255, 255, 0));
            this.addChild(pPath5);
            this.listener = new CrosshairDragHandler();
            this.addInputEventListener(this.listener);
        }

        class CrosshairDragHandler
        extends PDragEventHandler {
            CrosshairDragHandler() {
            }

            protected void drag(PInputEvent pInputEvent) {
                super.drag(pInputEvent);
                CrosshairGraphic.this.intensityReader.detachCrosshair();
            }

            protected void endDrag(PInputEvent pInputEvent) {
                super.endDrag(pInputEvent);
                CrosshairGraphic.this.intensityReader.crosshairDropped(pInputEvent);
            }
        }
    }

    class PairDragHandler
    extends PDragEventHandler {
        PairDragHandler() {
        }

        protected void drag(PInputEvent pInputEvent) {
            super.drag(pInputEvent);
            if (!IntensityReader.this.detached) {
                IntensityReader.this.crosshairGraphic.translate(pInputEvent.getCanvasDelta().getWidth(), pInputEvent.getCanvasDelta().getHeight());
            }
        }
    }

    static class TextReadout
    extends PhetPNode {
        private PText readout;
        private PPath textBackground = new PPath();

        public TextReadout() {
            this.textBackground.setPaint(new Color(255, 255, 255, 235));
            this.addChild(this.textBackground);
            this.readout = new PText(WIStrings.getString("readout.value-unknown"));
            this.readout.setFont(new PhetFont(1, 14));
            this.readout.setTextPaint(Color.blue);
            this.addChild(this.readout);
        }

        public void setText(String string) {
            this.readout.setText(string);
        }

        public void updateBackground() {
            this.textBackground.setPathTo(RectangleUtils.expand(this.readout.getFullBounds(), 10.0, 10.0));
        }
    }
}

