/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import edu.colorado.phet.waveinterference.model.Lattice2D;
import edu.colorado.phet.waveinterference.view.ColorMap;
import edu.colorado.phet.waveinterference.view.MutableColor;
import edu.colorado.phet.waveinterference.view.WaveValueReader;
import java.awt.Color;

public class IndexColorMap
implements ColorMap {
    private Lattice2D lattice;
    private float r;
    private float g;
    private float b;
    private Color[] colors;
    private int NUM_COLORS = 201;
    private WaveValueReader waveValueReader;
    private MutableColor color;

    public IndexColorMap(Lattice2D lattice2D) {
        this(lattice2D, new MutableColor(new Color(37, 179, 255)));
    }

    public IndexColorMap(Lattice2D lattice2D, MutableColor mutableColor) {
        this(lattice2D, mutableColor, (WaveValueReader)new WaveValueReader.Displacement());
    }

    public IndexColorMap(Lattice2D lattice2D, Color color, WaveValueReader waveValueReader) {
        this(lattice2D, new MutableColor(color), waveValueReader);
    }

    public IndexColorMap(Lattice2D lattice2D, MutableColor mutableColor, WaveValueReader waveValueReader) {
        this.waveValueReader = waveValueReader;
        this.color = mutableColor;
        this.lattice = lattice2D;
        mutableColor.addListener(new MutableColor.Listener(){

            public void colorChanged() {
                IndexColorMap.this.updateColors();
            }
        });
        this.updateColors();
    }

    private void updateColors() {
        this.r = (float)this.color.getRed() / 255.0f;
        this.g = (float)this.color.getGreen() / 255.0f;
        this.b = (float)this.color.getBlue() / 255.0f;
        this.colors = new Color[this.NUM_COLORS];
        for (int i = 0; i < this.colors.length - 1; ++i) {
            float f = (float)i / (float)this.colors.length;
            this.colors[i] = new Color(this.r * f, this.g * f, this.b * f);
        }
        float f = 1.0f;
        this.colors[this.colors.length - 1] = new Color(this.r * f, this.g * f, this.b * f);
    }

    public Color getColor(int n, int n2) {
        double d = this.waveValueReader.getValue(this.lattice, n, n2);
        int n3 = (int)(d * (double)(this.colors.length - 1));
        return this.colors[n3];
    }

    public Color getRootColor() {
        return new Color(this.r, this.g, this.b);
    }
}

