/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import edu.colorado.phet.common.phetcommon.view.HorizontalLayoutPanel;
import edu.colorado.phet.waveinterference.model.Oscillator;
import edu.colorado.phet.waveinterference.util.WIStrings;
import edu.colorado.phet.waveinterference.view.FaucetGraphic;
import edu.colorado.phet.waveinterference.view.PulseButton;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;

public class FaucetOnOffControlPanel
extends HorizontalLayoutPanel {
    private FaucetGraphic faucetGraphic;
    private JRadioButton onRadioButton;
    private JRadioButton offRadioButton;
    private PulseButton pulseButton;

    public FaucetOnOffControlPanel(final FaucetGraphic faucetGraphic) {
        this.faucetGraphic = faucetGraphic;
        ButtonGroup buttonGroup = new ButtonGroup();
        this.onRadioButton = new JRadioButton(WIStrings.getString("controls.on"), faucetGraphic.isEnabled());
        this.onRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                faucetGraphic.setEnabled(FaucetOnOffControlPanel.this.onRadioButton.isSelected());
            }
        });
        buttonGroup.add(this.onRadioButton);
        this.add(this.onRadioButton);
        this.offRadioButton = new JRadioButton(WIStrings.getString("controls.off"), !faucetGraphic.isEnabled());
        this.offRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                faucetGraphic.setEnabled(!FaucetOnOffControlPanel.this.offRadioButton.isSelected());
            }
        });
        buttonGroup.add(this.offRadioButton);
        this.add(this.offRadioButton);
        faucetGraphic.addListener(new FaucetGraphic.Listener(){

            public void enabledStateChanged() {
                FaucetOnOffControlPanel.this.updateState();
            }
        });
        faucetGraphic.getOscillator().addListener(new Oscillator.Adapter(){

            public void enabledStateChanged() {
                FaucetOnOffControlPanel.this.onRadioButton.setSelected(faucetGraphic.getOscillator().isEnabled());
                FaucetOnOffControlPanel.this.offRadioButton.setSelected(!faucetGraphic.getOscillator().isEnabled());
            }
        });
        this.updateState();
        this.pulseButton = new PulseButton(faucetGraphic.getOscillator());
        this.add(this.pulseButton);
    }

    private void updateState() {
        this.onRadioButton.setSelected(this.faucetGraphic.isEnabled());
        this.offRadioButton.setSelected(!this.faucetGraphic.isEnabled());
    }
}

