/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.waveinterference.phetcommon.VerticalConnector;
import edu.colorado.phet.waveinterference.view.FaucetControlPanelPNode;
import edu.colorado.phet.waveinterference.view.FaucetGraphic;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;

public class FaucetConnector
extends VerticalConnector {
    private FaucetControlPanelPNode faucetControlPanelPNode;
    private FaucetGraphic faucetGraphic;

    public FaucetConnector(FaucetControlPanelPNode faucetControlPanelPNode, FaucetGraphic faucetGraphic) {
        super(faucetGraphic.getImagePNode(), faucetControlPanelPNode);
        this.faucetControlPanelPNode = faucetControlPanelPNode;
        this.faucetGraphic = faucetGraphic;
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                FaucetConnector.this.update();
            }
        };
        faucetGraphic.addPropertyChangeListener("bounds", propertyChangeListener);
        faucetGraphic.addPropertyChangeListener("fullBounds", propertyChangeListener);
        faucetControlPanelPNode.addPropertyChangeListener("fullBounds", propertyChangeListener);
        faucetControlPanelPNode.addPropertyChangeListener("bounds", propertyChangeListener);
        try {
            this.setTexture(ImageLoader.loadBufferedImage("wave-interference/images/silverwire.png"));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.update();
    }

    protected void updateShape(Point2D point2D, Point2D point2D2) {
        if (this.faucetControlPanelPNode != null) {
            double d = Math.min(point2D.getY(), point2D2.getY());
            double d2 = Math.max(point2D.getY(), point2D2.getY());
            double d3 = d2 - d;
            Rectangle2D.Double double_ = new Rectangle2D.Double(this.faucetGraphic.getFullBounds().getX() + this.faucetGraphic.getFullBounds().getWidth() * 0.33, d, 20.0, d3);
            super.setPathTo(double_);
        }
    }
}

