/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.waveinterference.model.WaveModel;
import edu.colorado.phet.waveinterference.phetcommon.IconComponent;
import edu.colorado.phet.waveinterference.util.WIStrings;
import edu.colorado.phet.waveinterference.view.IntensityReaderSet;
import edu.colorado.phet.waveinterference.view.LatticeScreenCoordinates;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.JButton;

public class DetectorSetControlPanel
extends VerticalLayoutPanel {
    private IntensityReaderSet intensityReaderSet;
    private PhetPCanvas canvas;
    private WaveModel waveModel;
    private LatticeScreenCoordinates latticeScreenCoordinates;
    private IClock clock;

    public DetectorSetControlPanel(final String string, IntensityReaderSet intensityReaderSet, PhetPCanvas phetPCanvas, WaveModel waveModel, LatticeScreenCoordinates latticeScreenCoordinates, IClock iClock) {
        this.intensityReaderSet = intensityReaderSet;
        this.canvas = phetPCanvas;
        this.waveModel = waveModel;
        this.latticeScreenCoordinates = latticeScreenCoordinates;
        this.clock = iClock;
        JButton jButton = new JButton(WIStrings.getString("controls.add-detector"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DetectorSetControlPanel.this.addIntensityReader(string);
            }
        });
        this.add(new IconComponent(jButton, this.getDetectorImage()));
    }

    private BufferedImage getDetectorImage() {
        try {
            return ImageLoader.loadBufferedImage("wave-interference/images/detector-thumb.gif");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public void addIntensityReader(String string) {
        this.intensityReaderSet.addIntensityReader(string, this.canvas, this.waveModel, this.latticeScreenCoordinates, this.clock);
    }
}

