/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.view;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.waveinterference.model.WaveModel;
import edu.colorado.phet.waveinterference.view.AbstractScreenGraphic;
import edu.colorado.phet.waveinterference.view.LatticeScreenCoordinates;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class CurveScreenGraphic
extends AbstractScreenGraphic {
    private PPath path = new PPath();
    private PPath axis;
    private int intensityScale = 100;

    public CurveScreenGraphic(WaveModel waveModel, LatticeScreenCoordinates latticeScreenCoordinates) {
        super(waveModel, latticeScreenCoordinates);
        this.path.setStroke(new BasicStroke(1.0f));
        this.path.setStrokePaint(Color.black);
        this.axis = new PPath();
        this.axis.setStroke(new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{40.0f, 20.0f}, 0.0f));
        this.axis.setStrokePaint(Color.black);
        this.addChild(this.axis);
        this.axis.setVisible(false);
        this.addChild(this.path);
        this.update();
    }

    public void update() {
        this.axis.setPathTo(new Line2D.Double(0.0, this.getYValue(0), 0.0, this.getYValue(this.getWaveModel().getHeight())));
        this.path.reset();
        for (int i = 0; i < this.getWaveModel().getHeight(); ++i) {
            float f = this.getYValue(i);
            double d = this.getWaveModel().getAverageValue(this.getWaveModel().getWidth() - 1, i, 2);
            Vector2D vector2D = new Vector2D(this.getDx(), -this.getDy());
            double d2 = vector2D.getMagnitude();
            vector2D.normalize();
            vector2D.scale(d * (double)this.intensityScale);
            if (vector2D.getMagnitude() > d2) {
                vector2D = new Vector2D(this.getDx(), -this.getDy());
                if (d < 0.0) {
                    vector2D.scale(-1.0);
                }
            }
            Point2D.Double double_ = vector2D.getDestination(new Point2D.Double(0.0, f));
            if (i == 0) {
                this.path.moveTo((float)((Point2D)double_).getX(), (float)((Point2D)double_).getY());
                continue;
            }
            this.path.lineTo((float)((Point2D)double_).getX(), (float)((Point2D)double_).getY());
        }
        this.path.setOffset(0.0, (double)super.getCellHeight() / 2.0);
    }
}

