/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.tests;

import edu.colorado.phet.common.phetcommon.view.ModelSlider;
import edu.colorado.phet.waveinterference.tests.BasicWaveTestModule;
import edu.colorado.phet.waveinterference.view.IndexColorMap;
import edu.colorado.phet.waveinterference.view.RotationGlyph;
import edu.colorado.phet.waveinterference.view.RotationWaveGraphic;
import edu.colorado.phet.waveinterference.view.WaveModelGraphic;
import edu.colorado.phet.waveinterference.view.WaveRotateControl;
import edu.colorado.phet.waveinterference.view.WaveSideViewFull;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TestWaveRotateModule
extends BasicWaveTestModule {
    private RotationWaveGraphic rotationWaveGraphic;

    public TestWaveRotateModule() {
        this("Wave Rotate");
    }

    protected TestWaveRotateModule(String string) {
        super(string);
        final WaveModelGraphic waveModelGraphic = new WaveModelGraphic(this.getWaveModel(), 10, 10, new IndexColorMap(super.getLattice()));
        final WaveSideViewFull waveSideViewFull = new WaveSideViewFull(this.getWaveModel(), waveModelGraphic.getLatticeScreenCoordinates());
        RotationGlyph rotationGlyph = new RotationGlyph();
        this.rotationWaveGraphic = new RotationWaveGraphic(waveModelGraphic, waveSideViewFull, rotationGlyph);
        this.rotationWaveGraphic.setOffset(50.0, 20.0);
        this.getPhetPCanvas().addScreenChild(this.rotationWaveGraphic);
        final ModelSlider modelSlider = new ModelSlider("Cell Dimension", "pixels", 1.0, 50.0, waveSideViewFull.getDistBetweenCells());
        modelSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = (int)modelSlider.getValue();
                waveSideViewFull.setSpaceBetweenCells(n);
                waveModelGraphic.setCellDimensions(n, n);
            }
        });
        WaveRotateControl waveRotateControl = new WaveRotateControl(this.rotationWaveGraphic);
        this.getControlPanel().addControl(modelSlider);
        this.getControlPanel().addControl(waveRotateControl);
        this.rotationWaveGraphic.updateLocations();
        this.rotationWaveGraphic.setViewAngle(0.0);
    }

    protected void step() {
        super.step();
        this.rotationWaveGraphic.update();
    }
}

