/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.tests;

import edu.colorado.phet.waveinterference.WaveInterferenceModelUnits;
import edu.colorado.phet.waveinterference.model.SlitPotential;
import edu.colorado.phet.waveinterference.tests.TestTopView;
import edu.colorado.phet.waveinterference.view.ColorMap;
import edu.colorado.phet.waveinterference.view.PhotonEmissionColorMap;
import edu.colorado.phet.waveinterference.view.SRRWavelengthSliderComponent;
import edu.colorado.phet.waveinterference.view.ScreenControlPanel;
import edu.colorado.phet.waveinterference.view.ScreenNode;
import edu.colorado.phet.waveinterference.view.SlitControlPanel;
import edu.colorado.phet.waveinterference.view.SlitPotentialGraphic;
import edu.colorado.phet.waveinterference.view.WaveInterferenceScreenUnits;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TestSlitsAndScreen
extends TestTopView {
    private ScreenNode screenGraphic = new ScreenNode(this.getWaveModel(), this.getLatticeScreenCoordinates(), this.getWaveModelGraphic());
    private SRRWavelengthSliderComponent slider;

    public TestSlitsAndScreen() {
        super("Slits & Screen");
        this.getPhetPCanvas().addScreenChild(this.screenGraphic);
        this.getPhetPCanvas().removeScreenChild(this.getWaveModelGraphic());
        this.getPhetPCanvas().addScreenChild(this.getWaveModelGraphic());
        this.getWaveModelGraphic().setOffset(100.0, 100.0);
        SlitPotential slitPotential = new SlitPotential(this.getWaveModel());
        this.getWaveModel().setPotential(slitPotential);
        SlitPotentialGraphic slitPotentialGraphic = new SlitPotentialGraphic(slitPotential, this.getLatticeScreenCoordinates());
        this.getPhetPCanvas().addScreenChild(slitPotentialGraphic);
        this.getOscillator().setAmplitude(2.0);
        this.getControlPanel().addControlFullWidth(new SlitControlPanel(slitPotential, new WaveInterferenceScreenUnits(new WaveInterferenceModelUnits(), this.getLatticeScreenCoordinates())));
        this.getControlPanel().addControl(new ScreenControlPanel(this.screenGraphic));
        this.slider = new SRRWavelengthSliderComponent();
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                TestSlitsAndScreen.this.updateColor();
            }
        });
        this.getControlPanel().addControl(this.slider);
        this.updateColor();
        this.getOscillator().setAmplitude(2.5);
    }

    protected void updateColor() {
        this.getWaveModel().clear();
        PhotonEmissionColorMap photonEmissionColorMap = new PhotonEmissionColorMap(this.getWaveModel(), this.slider.getColor());
        this.setColorMap(photonEmissionColorMap);
    }

    protected void setColorMap(ColorMap colorMap) {
        this.getWaveModelGraphic().setColorMap(colorMap);
        if (this.screenGraphic != null) {
            this.screenGraphic.setColorMap(colorMap);
        }
    }

    protected void step() {
        super.step();
        this.screenGraphic.updateScreen();
    }
}

