/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.tests;

import edu.colorado.phet.common.phetcommon.view.ModelSlider;
import edu.colorado.phet.waveinterference.model.SlitPotential;
import edu.colorado.phet.waveinterference.tests.BasicWaveTestModule;
import edu.colorado.phet.waveinterference.view.IndexColorMap;
import edu.colorado.phet.waveinterference.view.PressureWaveGraphic;
import edu.colorado.phet.waveinterference.view.WaveModelGraphic;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TestPressureWaveModule
extends BasicWaveTestModule {
    private PressureWaveGraphic pressureWaveGraphic;
    private WaveModelGraphic waveModelGraphic = new WaveModelGraphic(this.getWaveModel(), 6, 6, new IndexColorMap(super.getLattice()));

    public TestPressureWaveModule() {
        super("Pressure View");
        this.waveModelGraphic.setVisible(false);
        this.waveModelGraphic.setOffset(50.0, 50.0);
        super.getPhetPCanvas().addScreenChild(this.waveModelGraphic);
        this.pressureWaveGraphic = new PressureWaveGraphic(this.getLattice(), this.waveModelGraphic.getLatticeScreenCoordinates(), new SlitPotential(this.getWaveModel()));
        this.getPhetPCanvas().addScreenChild(this.pressureWaveGraphic);
        final ModelSlider modelSlider = new ModelSlider("Cell Dimension", "pixels", 1.0, 50.0, this.pressureWaveGraphic.getDistBetweenCells());
        modelSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = (int)modelSlider.getValue();
                TestPressureWaveModule.this.pressureWaveGraphic.setSpaceBetweenCells(n);
                TestPressureWaveModule.this.waveModelGraphic.setCellDimensions(n, n);
            }
        });
        final JCheckBox jCheckBox = new JCheckBox("Show Lattice", this.waveModelGraphic.getVisible());
        jCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                TestPressureWaveModule.this.waveModelGraphic.setVisible(jCheckBox.isSelected());
            }
        });
        final ModelSlider modelSlider2 = new ModelSlider("Particle Size", "pixels", 1.0, 36.0, this.pressureWaveGraphic.getImageSize());
        modelSlider2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                TestPressureWaveModule.this.pressureWaveGraphic.setParticleImageSize((int)modelSlider2.getValue());
            }
        });
        final ModelSlider modelSlider3 = new ModelSlider("Particle Acceleration", "", 0.0, 10.0, this.pressureWaveGraphic.getParticleAcceleration());
        modelSlider3.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                TestPressureWaveModule.this.pressureWaveGraphic.setParticleAcceleration(modelSlider3.getValue());
            }
        });
        final ModelSlider modelSlider4 = new ModelSlider("Particle Max Velocity", "pixels/sec", 0.0, 30.0, this.pressureWaveGraphic.getMaxVelocity());
        modelSlider4.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                TestPressureWaveModule.this.pressureWaveGraphic.setMaxVelocity(modelSlider4.getValue());
            }
        });
        final ModelSlider modelSlider5 = new ModelSlider("Friction", "scale", 0.0, 1.0, this.pressureWaveGraphic.getFriction());
        modelSlider5.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                TestPressureWaveModule.this.pressureWaveGraphic.setFriction(modelSlider5.getValue());
            }
        });
        this.getControlPanel().addControl(modelSlider);
        this.getControlPanel().addControl(jCheckBox);
        this.getControlPanel().addControl(modelSlider2);
        this.getControlPanel().addControl(modelSlider3);
        this.getControlPanel().addControl(modelSlider4);
        this.getControlPanel().addControl(modelSlider5);
    }

    protected void step() {
        super.step();
        this.waveModelGraphic.update();
        this.pressureWaveGraphic.update();
    }
}

