/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.tests;

import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.waveinterference.util.WIStrings;
import edu.colorado.phet.waveinterference.view.LatticeScreenCoordinates;
import edu.colorado.phet.waveinterference.view.WaveChartGraphic;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class ExpandableWaveChart
extends PNode {
    private WaveChartGraphic waveChartGraphic;
    private PSwing expandPSwing;
    private boolean expanded = false;
    private PNode collapsePSwing;
    private ArrayList listeners = new ArrayList();
    private LatticeScreenCoordinates latticeScreenCoordinates;

    public ExpandableWaveChart(WaveChartGraphic waveChartGraphic, LatticeScreenCoordinates latticeScreenCoordinates) {
        this.latticeScreenCoordinates = latticeScreenCoordinates;
        JButton jButton = new JButton(WIStrings.getString("chart.show-graph"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExpandableWaveChart.this.setExpanded(true);
            }
        });
        JButton jButton2 = null;
        try {
            jButton2 = new JButton(new ImageIcon(ImageLoader.loadBufferedImage("wave-interference/images/x-20.png")));
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ExpandableWaveChart.this.setExpanded(false);
                }
            });
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.addChild(waveChartGraphic);
        this.expandPSwing = new PSwing(jButton);
        this.collapsePSwing = new PSwing(jButton2);
        this.addChild(waveChartGraphic);
        this.waveChartGraphic = waveChartGraphic;
        waveChartGraphic.addPropertyChangeListener("fullBounds", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ExpandableWaveChart.this.updateLocations();
            }
        });
        latticeScreenCoordinates.addListener(new LatticeScreenCoordinates.Listener(){

            public void mappingChanged() {
                ExpandableWaveChart.this.updateLocations();
            }
        });
        this.updateLocations();
        this.addChild(this.expandPSwing);
        this.update();
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean bl) {
        this.expanded = bl;
        this.update();
        this.notifyExpansionStateChanged();
    }

    private void update() {
        this.removeAllChildren();
        if (this.expanded) {
            this.addChild(this.waveChartGraphic);
            this.addChild(this.collapsePSwing);
            this.updateChart();
        } else {
            this.addChild(this.expandPSwing);
        }
        this.updateLocations();
    }

    private void updateLocations() {
        double d = this.waveChartGraphic.getChartBounds().getCenterX() - this.expandPSwing.getFullBounds().getWidth() / 2.0;
        double d2 = this.waveChartGraphic.getChartBounds().getMaxX() - this.collapsePSwing.getFullBounds().getWidth();
        double d3 = this.waveChartGraphic.getChartBounds().getY();
        this.expandPSwing.setOffset(d, d3);
        this.collapsePSwing.setOffset(d2, d3);
    }

    public void updateChart() {
        if (this.waveChartGraphic.getVisible()) {
            this.waveChartGraphic.updateChart();
        }
    }

    public void setColor(Color color) {
        this.waveChartGraphic.setCurveColor(color);
    }

    public void reset() {
        this.setExpanded(false);
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void notifyExpansionStateChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).expansionStateChanged();
        }
    }

    public static interface Listener {
        public void expansionStateChanged();
    }
}

