/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.tests;

import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.model.clock.SwingClock;
import edu.colorado.phet.common.piccolophet.BufferedPhetPCanvas;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.waveinterference.model.Lattice2D;
import edu.colorado.phet.waveinterference.model.Oscillator;
import edu.colorado.phet.waveinterference.model.WaveModel;
import edu.colorado.phet.waveinterference.tests.BasicWaveTestControlPanel;

public class BasicWaveTestModule
extends Module {
    private WaveModel waveModel;
    private Oscillator oscillator;
    private PhetPCanvas panel = new BufferedPhetPCanvas();
    private static double initialTime = (double)System.currentTimeMillis() / 1000.0;

    public BasicWaveTestModule(String string) {
        super(string, new SwingClock(30, 1.0));
        this.setSimulationPanel(this.panel);
        this.waveModel = new WaveModel(80, 80);
        this.oscillator = new Oscillator(this.waveModel);
        this.addModelElement(new ModelElement(){

            public void stepInTime(double d) {
                BasicWaveTestModule.this.step();
            }
        });
        BasicWaveTestControlPanel basicWaveTestControlPanel = new BasicWaveTestControlPanel(this);
        this.setControlPanel(basicWaveTestControlPanel);
    }

    public Oscillator getOscillator() {
        return this.oscillator;
    }

    public WaveModel getWaveModel() {
        return this.waveModel;
    }

    public void setOscillatorRadius(int n) {
        this.oscillator.setRadius(n);
    }

    public void setLatticeSize(int n, int n2) {
        this.waveModel.setSize(n, n2);
    }

    protected void step() {
        double d = this.getTime();
        this.oscillator.setTime(d);
        this.waveModel.propagate();
    }

    protected double getTime() {
        return (double)System.currentTimeMillis() / 1000.0 - initialTime;
    }

    public Lattice2D getLattice() {
        return this.waveModel.getLattice();
    }

    public PhetPCanvas getPhetPCanvas() {
        return this.panel;
    }

    public double getPeriod() {
        return this.oscillator.getPeriod();
    }

    public void setPeriod(double d) {
        this.oscillator.setPeriod(d);
    }
}

