/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.sound;

import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.waveinterference.util.WIStrings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AudioControlPanel
extends JPanel {
    private JSlider _soundSlider;
    private JCheckBox _soundCheckBox;
    public static final Insets DEFAULT_INSETS = new Insets(0, 0, 0, 0);
    private ArrayList listeners = new ArrayList();

    public AudioControlPanel() {
        JLabel jLabel;
        Serializable serializable;
        JLabel jLabel2;
        Accessible accessible;
        this.setBorder(BorderFactory.createTitledBorder(WIStrings.getString("sound.audio")));
        this._soundCheckBox = new JCheckBox(WIStrings.getString("module.sound"));
        try {
            accessible = new ImageIcon(ImageLoader.loadBufferedImage("wave-interference/images/soundMin.png"));
            jLabel2 = new JLabel((Icon)((Object)accessible));
            serializable = new ImageIcon(ImageLoader.loadBufferedImage("wave-interference/images/soundMax.png"));
            jLabel = new JLabel((Icon)((Object)serializable));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            jLabel2 = new JLabel("-");
            jLabel = new JLabel("+");
        }
        this._soundSlider = new JSlider();
        this._soundSlider.setMaximum(100);
        this._soundSlider.setMinimum(0);
        this._soundSlider.setValue(50);
        this._soundSlider.setPreferredSize(new Dimension(125, this._soundSlider.getPreferredSize().height));
        accessible = new JPanel();
        serializable = new EasyGridBagLayout((JPanel)accessible);
        ((Container)((Object)accessible)).setLayout((LayoutManager)((Object)serializable));
        ((EasyGridBagLayout)serializable).setInsets(DEFAULT_INSETS);
        ((EasyGridBagLayout)serializable).setAnchor(17);
        ((EasyGridBagLayout)serializable).addComponent(this._soundCheckBox, 0, 3);
        ((EasyGridBagLayout)serializable).addComponent(jLabel2, 1, 2);
        ((EasyGridBagLayout)serializable).addComponent(this._soundSlider, 1, 3);
        ((EasyGridBagLayout)serializable).addComponent(jLabel, 1, 4);
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)accessible), "West");
        this._soundSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                AudioControlPanel.this.notifyAmplitudeChanged();
            }
        });
        this._soundCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AudioControlPanel.this.notifyEnableStateChanged();
            }
        });
    }

    private void notifyAmplitudeChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.amplitudeChanged();
        }
    }

    private void notifyEnableStateChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.audioEnabledChanged();
        }
    }

    public boolean isAudioEnabled() {
        return this._soundCheckBox.isSelected();
    }

    public double getVolume() {
        return (double)this._soundSlider.getValue() / 100.0;
    }

    public void updateAudioEnabled(boolean bl) {
        this._soundCheckBox.setSelected(bl);
    }

    public void updateVolume(double d) {
        this._soundSlider.setValue((int)(d * 100.0));
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public static interface Listener {
        public void audioEnabledChanged();

        public void amplitudeChanged();
    }
}

