/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.phetcommon;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;

public class ShinyPanel
extends JPanel {
    private Color lightGray;
    private Color shadedGray;

    public ShinyPanel(JComponent jComponent) {
        this(jComponent, new Color(80, 80, 80), new Color(20, 20, 20));
    }

    public ShinyPanel(JComponent jComponent, Color color, Color color2) {
        this.lightGray = color;
        this.shadedGray = color2;
        this.setLayout(new BorderLayout());
        this.add((Component)jComponent, "Center");
        this.setOpaque(this, false);
        this.setBorder(new ShinyBorder());
    }

    private void setOpaque(JComponent jComponent, boolean bl) {
        if (jComponent instanceof JButton) {
            jComponent.setForeground(Color.black);
            jComponent.setBackground(Color.white);
        } else {
            jComponent.setOpaque(bl);
            jComponent.setBackground(new Color(255, 255, 255, 0));
            jComponent.setForeground(Color.white);
        }
        for (int i = 0; i < jComponent.getComponentCount(); ++i) {
            Component component = jComponent.getComponent(i);
            if (!(component instanceof JComponent) || component instanceof JTextComponent) continue;
            this.setOpaque((JComponent)component, bl);
        }
    }

    protected void paintComponent(Graphics graphics) {
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, this.lightGray, this.getWidth(), this.getHeight(), this.shadedGray, true);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        super.paintComponent(graphics);
    }

    public static class ShinyBorder
    extends CompoundBorder {
        public ShinyBorder() {
            super(ShinyBorder.createCompoundBorder(), new EmptyBorder(0, 0, 0, 0));
        }

        protected static CompoundBorder createCompoundBorder() {
            Color[] colorArray = new Color[8];
            for (int i = 0; i < colorArray.length; ++i) {
                float f = (float)i / (float)(colorArray.length - 1);
                colorArray[i] = new Color(1.0f - f, 1.0f - f, 1.0f - f);
            }
            BevelBorder bevelBorder = new BevelBorder(0, colorArray[0], colorArray[1], colorArray[7], colorArray[6]);
            BevelBorder bevelBorder2 = new BevelBorder(0, colorArray[2], colorArray[3], colorArray[5], colorArray[4]);
            return new CompoundBorder(bevelBorder, bevelBorder2);
        }
    }
}

