/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.model;

import edu.colorado.phet.waveinterference.model.ConstantPotential;
import edu.colorado.phet.waveinterference.model.Potential;
import edu.colorado.phet.waveinterference.model.VerticalBarrier;
import edu.colorado.phet.waveinterference.model.VerticalDoubleSlit;
import edu.colorado.phet.waveinterference.model.VerticalSingleSlit;
import edu.colorado.phet.waveinterference.model.WaveModel;
import java.awt.Rectangle;
import java.util.ArrayList;

public class SlitPotential
implements Potential {
    private WaveModel waveModel;
    private boolean enabled = false;
    private int slitWidth = 10;
    private int slitSeparation = 12;
    private int thickness = 2;
    private double potentialValue = 100.0;
    private int location;
    private boolean oneSlit = true;
    private Potential potential;
    private ArrayList listeners = new ArrayList();

    private SlitPotential(WaveModel waveModel, boolean bl) {
        this.waveModel = waveModel;
        this.location = (int)((double)waveModel.getWidth() * 0.75);
    }

    public SlitPotential(WaveModel waveModel) {
        this(waveModel, true);
        waveModel.addListener(new WaveModel.Listener(){

            public void sizeChanged() {
                SlitPotential.this.update();
            }
        });
        this.update();
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public boolean isOneSlit() {
        return this.oneSlit;
    }

    public boolean isTwoSlits() {
        return !this.isOneSlit();
    }

    public void reset() {
        SlitPotential slitPotential = new SlitPotential(this.waveModel, true);
        this.setEnabled(slitPotential.enabled);
        this.setSlitWidth(slitPotential.slitWidth);
        this.setLocation(slitPotential.location);
        if (slitPotential.oneSlit) {
            this.setOneSlit();
        } else {
            this.setTwoSlits();
        }
        this.setSlitSeparation(slitPotential.slitSeparation);
    }

    private void update() {
        this.potential = !this.enabled ? new ConstantPotential() : (this.oneSlit ? new VerticalSingleSlit(this.waveModel.getWidth(), this.waveModel.getHeight(), this.location, this.thickness, this.slitWidth, this.slitSeparation, this.potentialValue) : new VerticalDoubleSlit(this.waveModel.getWidth(), this.waveModel.getHeight(), this.location, this.thickness, this.slitWidth, this.slitSeparation, this.potentialValue));
        this.notifySlitsChanged();
    }

    private void notifySlitsChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.slitsChanged();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        if (this.enabled != bl) {
            this.enabled = bl;
            this.update();
        }
    }

    public void setOneSlit() {
        this.oneSlit = true;
        this.update();
    }

    public void setTwoSlits() {
        this.oneSlit = false;
        this.update();
    }

    public void setSlitWidth(int n) {
        this.slitWidth = n;
        this.update();
    }

    public int getSlitWidth() {
        return this.slitWidth;
    }

    public int getSlitSeparation() {
        return this.slitSeparation;
    }

    public void setSlitSeparation(int n) {
        this.slitSeparation = n;
        this.update();
    }

    public int getLocation() {
        return this.location;
    }

    public void setLocation(int n) {
        this.location = n;
        this.update();
    }

    public double getPotential(int n, int n2, int n3) {
        return this.potential.getPotential(n, n2, n3);
    }

    public Rectangle[] getBarrierRectangles() {
        if (this.potential instanceof ConstantPotential) {
            return new Rectangle[0];
        }
        if (this.potential instanceof VerticalBarrier) {
            return ((VerticalBarrier)this.potential).getRectangleBarriers();
        }
        System.err.println("Unknown type for barriers: " + this.potential.getClass());
        return new Rectangle[0];
    }

    public static interface Listener {
        public void slitsChanged();
    }
}

