/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.model;

import edu.colorado.phet.waveinterference.model.Potential;

public class PrecomputedPotential
implements Potential {
    private Potential potential;
    private double[][] potentialValues;

    public PrecomputedPotential(Potential potential, int n, int n2) {
        this.potential = potential;
        this.update(n, n2);
    }

    protected void update(int n, int n2) {
        this.potentialValues = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.potentialValues[i][j] = this.potential.getPotential(i, j, 0);
            }
        }
    }

    public double getPotential(int n, int n2, int n3) {
        if (n < 0 || n >= this.potentialValues.length || n2 < 0 || n2 >= this.potentialValues[0].length) {
            return 0.0;
        }
        return this.potentialValues[n][n2];
    }
}

