/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.model;

import java.awt.Dimension;
import java.awt.Rectangle;

public class Lattice2D {
    float[][] wavefunction;

    public Lattice2D(int n, int n2) {
        this.wavefunction = new float[n][n2];
        this.clear();
    }

    public Lattice2D(float[][] fArray) {
        this.wavefunction = fArray;
    }

    public double getAverageValue(int n, int n2, int n3) {
        double d = 0.0;
        int n4 = 0;
        for (int i = n - n3; i <= n + n3; ++i) {
            for (int j = n2 - n3; j <= n2 + n3; ++j) {
                if (!this.containsLocation(i, j)) continue;
                d += (double)this.getValue(i, j);
                ++n4;
            }
        }
        return d / (double)n4;
    }

    public Dimension getSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public boolean containsLocation(int n, int n2) {
        return this.getBounds().contains(n, n2);
    }

    public void copyTo(Lattice2D lattice2D) {
        lattice2D.setSize(this.getWidth(), this.getHeight());
        int n = this.getWidth();
        int n2 = this.getHeight();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                lattice2D.wavefunction[i][j] = this.wavefunction[i][j];
            }
        }
    }

    public int getWidth() {
        return this.wavefunction.length;
    }

    public int getHeight() {
        return this.wavefunction[0].length;
    }

    public void setValue(int n, int n2, float f) {
        this.wavefunction[n][n2] = f;
    }

    public float getValue(int n, int n2) {
        return this.wavefunction[n][n2];
    }

    public void clear() {
        for (int i = 0; i < this.getWidth(); ++i) {
            for (int j = 0; j < this.getHeight(); ++j) {
                this.setValue(i, j, 0.0f);
            }
        }
    }

    public void setSize(int n, int n2) {
        if (this.getWidth() != n || this.getHeight() != n2) {
            this.wavefunction = new float[n][n2];
            this.clear();
        }
    }

    public Lattice2D copy() {
        float[][] fArray = new float[this.getWidth()][this.getHeight()];
        for (int i = 0; i < this.getWidth(); ++i) {
            for (int j = 0; j < this.getHeight(); ++j) {
                fArray[i][j] = this.getValue(i, j);
            }
        }
        return new Lattice2D(fArray);
    }

    public Rectangle getBounds() {
        return new Rectangle(this.getWidth(), this.getHeight());
    }
}

