/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference.model;

import edu.colorado.phet.waveinterference.model.Potential;
import java.util.ArrayList;

public class CompositePotential
implements Potential {
    private ArrayList<Potential> p = new ArrayList();
    private ArrayList listeners = new ArrayList();

    public void addPotential(Potential potential) {
        this.p.add(potential);
        this.notifyPotentialAdded();
    }

    public double getPotential(int n, int n2, int n3) {
        double d = 0.0;
        for (int i = 0; i < this.p.size(); ++i) {
            Potential potential = this.p.get(i);
            d += potential.getPotential(n, n2, n3);
        }
        return d;
    }

    public void clear() {
        this.p.clear();
    }

    public void removePotential(Potential potential) {
        this.p.remove(potential);
        this.notifyPotentialRemoved();
    }

    public int numPotentials() {
        return this.p.size();
    }

    public Potential getPotential(int n) {
        return this.p.get(n);
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void notifyPotentialRemoved() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).potentialRemoved();
        }
    }

    public void notifyPotentialAdded() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).potentialAdded();
        }
    }

    public static interface Listener {
        public void potentialAdded();

        public void potentialRemoved();
    }
}

