/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.waveinterference.WaveInterferenceModelUnits;
import edu.colorado.phet.waveinterference.model.CompositePotential;
import edu.colorado.phet.waveinterference.model.Oscillator;
import edu.colorado.phet.waveinterference.model.SlitPotential;
import edu.colorado.phet.waveinterference.model.WaveModel;
import java.util.ArrayList;

public class WaveInterferenceModel
implements ModelElement {
    private WaveModel waveModel;
    private SlitPotential slitPotential;
    private CompositePotential compositePotential = new CompositePotential();
    private CompositePotential wallPotentials = new CompositePotential();
    private Oscillator primaryOscillator;
    private Oscillator secondaryOscillator;
    private double time = 0.0;
    private ArrayList listeners = new ArrayList();
    private WaveInterferenceModelUnits modelUnits = new WaveInterferenceModelUnits();

    public WaveInterferenceModel() {
        this(20, 20);
    }

    public WaveInterferenceModel(int n, int n2) {
        this.waveModel = new WaveModel(60, 60, n, n2);
        this.slitPotential = new SlitPotential(this.waveModel);
        this.primaryOscillator = new Oscillator(this.waveModel);
        this.secondaryOscillator = new Oscillator(this.waveModel);
        this.initSecondaryOscillator();
        this.waveModel.setPotential(this.compositePotential);
        this.compositePotential.addPotential(this.wallPotentials);
        this.compositePotential.addPotential(this.slitPotential);
        this.slitPotential.addListener(new SlitPotential.Listener(){

            public void slitsChanged() {
                WaveInterferenceModel.this.notifySymmetryChanged();
            }
        });
        this.secondaryOscillator.addListener(new Oscillator.Listener(){

            public void enabledStateChanged() {
                WaveInterferenceModel.this.notifySymmetryChanged();
            }

            public void locationChanged() {
            }

            public void frequencyChanged() {
            }

            public void amplitudeChanged() {
            }
        });
    }

    private void initSecondaryOscillator() {
        this.secondaryOscillator.setEnabled(false);
        this.secondaryOscillator.setLocation(10, 10);
    }

    public void setDistanceUnits(String string) {
        this.modelUnits.setDistanceUnits(string);
    }

    public void setTimeUnits(String string) {
        this.modelUnits.setTimeUnits(string);
    }

    public void setTimeScale(double d) {
        this.modelUnits.setTimeScale(d);
    }

    public void setPhysicalSize(double d, double d2) {
        this.modelUnits.setPhysicalSize(d, d2);
    }

    public String getDistanceUnits() {
        return this.modelUnits.getDistanceUnits();
    }

    public double getPhysicalWidth() {
        return this.modelUnits.getPhysicalWidth();
    }

    public double getPhysicalHeight() {
        return this.modelUnits.getPhysicalHeight();
    }

    public String getTimeUnits() {
        return this.modelUnits.getTimeUnits();
    }

    public double getTimeScale() {
        return this.modelUnits.getTimeScale();
    }

    public WaveInterferenceModelUnits getUnits() {
        return this.modelUnits;
    }

    public void reset() {
        this.waveModel.clear();
        this.slitPotential.reset();
        this.time = 0.0;
        this.primaryOscillator.reset();
        this.secondaryOscillator.reset();
        this.wallPotentials.clear();
    }

    public void setInitialConditions() {
        this.primaryOscillator.saveState();
        this.secondaryOscillator.saveState();
    }

    public CompositePotential getWallPotentials() {
        return this.wallPotentials;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    protected void notifySymmetryChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.symmetryChanged();
        }
    }

    public WaveModel getWaveModel() {
        return this.waveModel;
    }

    public SlitPotential getSlitPotential() {
        return this.slitPotential;
    }

    public Oscillator getPrimaryOscillator() {
        return this.primaryOscillator;
    }

    public Oscillator getSecondaryOscillator() {
        return this.secondaryOscillator;
    }

    public void stepInTime(double d) {
        this.time += d;
        this.waveModel.propagate();
        this.primaryOscillator.setTime(this.getTime());
        this.secondaryOscillator.setTime(this.getTime());
    }

    private double getTime() {
        return this.time;
    }

    public boolean isSymmetric() {
        return !this.slitPotential.isEnabled() && !this.getSecondaryOscillator().isEnabled();
    }

    public static interface Listener {
        public void symmetryChanged();
    }
}

