/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference;

import edu.colorado.phet.common.phetcommon.application.ApplicationConstructor;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.piccolophet.PiccoloPhetApplication;
import edu.colorado.phet.waveinterference.ColorizeCheckBoxMenuItem;
import edu.colorado.phet.waveinterference.LightModule;
import edu.colorado.phet.waveinterference.SoundModule;
import edu.colorado.phet.waveinterference.WaterModule;
import edu.colorado.phet.waveinterference.WaveInterferenceMenu;

public class WaveInterferenceApplication
extends PiccoloPhetApplication {
    public WaveInterferenceApplication(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig);
        WaveInterferenceMenu waveInterferenceMenu = new WaveInterferenceMenu();
        this.addModule(new WaterModule());
        this.addModule(new SoundModule(phetApplicationConfig.isDev()));
        LightModule lightModule = new LightModule();
        this.addModule(lightModule);
        waveInterferenceMenu.add(new ColorizeCheckBoxMenuItem(lightModule));
        if (phetApplicationConfig.isDev()) {
            this.getPhetFrame().addMenu(waveInterferenceMenu);
        }
        if (this.getModules().length > 1) {
            for (int i = 0; i < this.getModules().length; ++i) {
                this.getModule(i).setLogoPanelVisible(false);
            }
        }
    }

    public static void main(String[] stringArray) {
        ApplicationConstructor applicationConstructor = new ApplicationConstructor(){

            public PhetApplication getApplication(PhetApplicationConfig phetApplicationConfig) {
                return new WaveInterferenceApplication(phetApplicationConfig);
            }
        };
        PhetApplicationConfig phetApplicationConfig = new PhetApplicationConfig(stringArray, "wave-interference");
        new PhetApplicationLauncher().launchSim(phetApplicationConfig, applicationConstructor);
    }
}

