/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference;

import edu.colorado.phet.waveinterference.model.Potential;
import edu.colorado.phet.waveinterference.model.WaveModel;
import java.awt.BasicStroke;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.util.ArrayList;

public class WallPotential
implements Potential {
    private Point srcPoint;
    private Point dstPoint;
    private WaveModel waveModel;
    private int thickness = 3;
    private Shape shape;
    private ArrayList listeners = new ArrayList();

    public WallPotential(Point point, Point point2, WaveModel waveModel) {
        this.srcPoint = point;
        this.dstPoint = point2;
        this.waveModel = waveModel;
        this.update();
    }

    private void update() {
        Line2D.Double double_ = new Line2D.Double(this.srcPoint, this.dstPoint);
        this.shape = new BasicStroke(this.thickness).createStrokedShape(double_);
    }

    public void setSrcPoint(Point point) {
        this.srcPoint = point;
        this.update();
        this.notifyListener();
    }

    public void setDstPoint(Point point) {
        this.dstPoint = point;
        this.update();
        this.notifyListener();
    }

    public int getThickness() {
        return this.thickness;
    }

    public double getPotential(int n, int n2, int n3) {
        return this.waveModel.containsLocation(n, n2) && this.shape.contains(n, n2) ? 100.0 : 0.0;
    }

    public Point getSource() {
        return this.srcPoint;
    }

    public Point getDestination() {
        return this.dstPoint;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void notifyListener() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).changed();
        }
    }

    public static interface Listener {
        public void changed();
    }
}

