/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.view.graphics.Arrow;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.waveinterference.util.WIStrings;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PAffineTransform;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Point2D;

public class ThisSideUpGraphic
extends PhetPNode {
    private double origHeight;

    public ThisSideUpGraphic() {
        PText pText = new PText(WIStrings.getString("controls.top"));
        this.addChild(pText);
        PPath pPath = new PPath(new Arrow(new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, -100.0), 30.0, 30.0, 15.0).getShape());
        pPath.setPaint(Color.yellow);
        pPath.setStroke(new BasicStroke(2.0f));
        pPath.setStrokePaint(Color.black);
        this.addChild(pPath);
        pText.setFont(new PhetFont(1, 24));
        pPath.setOffset(pText.getFullBounds().getWidth() + pPath.getFullBounds().getWidth() / 2.0, pText.getFullBounds().getHeight() / 2.0 + pPath.getFullBounds().getHeight() / 2.0);
        this.origHeight = this.getFullBounds().getHeight();
    }

    public void setAngle(double d) {
        if (d > 0.0) {
            this.setVisible(true);
            Function.LinearFunction linearFunction = new Function.LinearFunction(0.0, 1.5707963267948966, 0.0, 1.0);
            double d2 = linearFunction.evaluate(d);
            double d3 = d2 * this.origHeight / 2.0;
            PAffineTransform pAffineTransform = this.getTransformReference(true);
            this.getTransformReference(true).setTransform(1.0, pAffineTransform.getShearY(), pAffineTransform.getShearX(), d2, pAffineTransform.getTranslateX(), d3);
            this.invalidatePaint();
            this.invalidateFullBounds();
            this.firePropertyChange(8, "transform", null, this.getTransform());
        } else {
            this.setVisible(false);
        }
    }
}

