/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference;

import edu.colorado.phet.waveinterference.view.LatticeScreenCoordinates;
import edu.colorado.phet.waveinterference.view.PressureWaveGraphic;
import edu.colorado.phet.waveinterference.view.WaveModelGraphic;
import edu.umd.cs.piccolo.PNode;
import java.util.ArrayList;

public class SoundWaveGraphic
extends PNode {
    private PressureWaveGraphic pressureWaveGraphic;
    private WaveModelGraphic waveModelGraphic;
    private double particleSize = 0.75;
    private boolean grayscaleVisible = true;
    private boolean particlesVisible = false;
    private ArrayList listeners = new ArrayList();

    public SoundWaveGraphic(WaveModelGraphic waveModelGraphic, PressureWaveGraphic pressureWaveGraphic) {
        this.waveModelGraphic = waveModelGraphic;
        this.pressureWaveGraphic = pressureWaveGraphic;
        this.addChild(waveModelGraphic);
        this.addChild(pressureWaveGraphic);
        this.updateView();
    }

    public void reset() {
        this.setParticlesVisible(false);
        this.setGrayscaleVisible(true);
        this.notifyViewChanged();
        this.pressureWaveGraphic.reset();
    }

    public PressureWaveGraphic getPressureWaveGraphic() {
        return this.pressureWaveGraphic;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    private void notifyViewChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.viewChanged();
        }
    }

    private void updateView() {
        this.pressureWaveGraphic.setVisible(this.particlesVisible);
        this.waveModelGraphic.setVisible(this.grayscaleVisible);
        int n = (int)(this.particleSize * 21.0);
        this.pressureWaveGraphic.setParticleImageSize(Math.max(1, n));
    }

    public LatticeScreenCoordinates getLatticeScreenCoordinates() {
        return this.waveModelGraphic.getLatticeScreenCoordinates();
    }

    public void update() {
        this.waveModelGraphic.update();
        this.pressureWaveGraphic.update();
        this.notifyViewChanged();
    }

    public void setGrayscaleVisible(boolean bl) {
        this.grayscaleVisible = bl;
        this.updateView();
        this.notifyViewChanged();
        this.notifyViewTypeChanged();
    }

    public boolean isGrayscaleVisible() {
        return this.grayscaleVisible;
    }

    public void setParticlesVisible(boolean bl) {
        this.particlesVisible = bl;
        this.updateView();
        this.notifyViewChanged();
        this.notifyViewTypeChanged();
    }

    private void notifyViewTypeChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.viewTypeChanged();
        }
    }

    public boolean isParticleVisible() {
        return this.particlesVisible;
    }

    public WaveModelGraphic getWaveModelGraphic() {
        return this.waveModelGraphic;
    }

    public static interface Listener {
        public void viewChanged();

        public void viewTypeChanged();
    }
}

