/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference;

import edu.colorado.phet.waveinterference.WaveInterferenceModel;
import edu.colorado.phet.waveinterference.model.Oscillator;
import edu.colorado.phet.waveinterference.sound.FourierSoundPlayer;
import java.util.ArrayList;
import javax.sound.sampled.LineUnavailableException;

public class SoundModuleAudio {
    private FourierSoundPlayer fourierSoundPlayer;
    private WaveInterferenceModel waveInterferenceModel;
    private double volume = 1.0;
    private ArrayList listeners = new ArrayList();

    public SoundModuleAudio(WaveInterferenceModel waveInterferenceModel) {
        this.waveInterferenceModel = waveInterferenceModel;
        try {
            this.fourierSoundPlayer = new FourierSoundPlayer();
        }
        catch (LineUnavailableException lineUnavailableException) {
            lineUnavailableException.printStackTrace();
        }
        waveInterferenceModel.getPrimaryOscillator().addListener(new Oscillator.Listener(){

            public void enabledStateChanged() {
            }

            public void locationChanged() {
            }

            public void frequencyChanged() {
                SoundModuleAudio.this.updateFrequency();
            }

            public void amplitudeChanged() {
                SoundModuleAudio.this.updateAmplitude();
            }
        });
        this.updateFrequency();
        this.updateAmplitude();
    }

    private void updateAmplitude() {
        if (this.fourierSoundPlayer != null) {
            this.fourierSoundPlayer.setVolume(Math.min(1.0f, (float)this.volume * this.getPrimaryAmplitude()));
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.volumeChanged();
        }
    }

    private void updateFrequency() {
        this.fourierSoundPlayer.setFrequency(this.getPrimaryFrequency() * 880.0);
    }

    private double getPrimaryFrequency() {
        return this.waveInterferenceModel.getPrimaryOscillator().getFrequency();
    }

    public void setAudioEnabled(boolean bl) {
        if (this.fourierSoundPlayer != null) {
            this.fourierSoundPlayer.setSoundEnabled(bl && this.isPrimaryOscillatorEnabled());
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.audioEnabledChanged();
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    private boolean isPrimaryOscillatorEnabled() {
        return this.waveInterferenceModel.getPrimaryOscillator().isEnabled();
    }

    public void setVolume(double d) {
        this.volume = d;
        this.updateAmplitude();
    }

    private float getPrimaryAmplitude() {
        return (float)this.waveInterferenceModel.getPrimaryOscillator().getAmplitude();
    }

    public void setActive(boolean bl) {
        this.fourierSoundPlayer.setActive(bl);
    }

    public void reset() {
        this.setAudioEnabled(false);
        this.setVolume(0.5);
    }

    public boolean isAudioEnabled() {
        return this.fourierSoundPlayer.isEnabled();
    }

    public double getVolume() {
        return this.volume;
    }

    public static interface Listener {
        public void audioEnabledChanged();

        public void volumeChanged();
    }
}

