/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference;

import edu.colorado.phet.common.phetcommon.view.ModelSlider;
import edu.colorado.phet.waveinterference.AddWallPotentialButton;
import edu.colorado.phet.waveinterference.ResetModuleControl;
import edu.colorado.phet.waveinterference.ShowMarkersControl;
import edu.colorado.phet.waveinterference.SoundAudioControlPanel;
import edu.colorado.phet.waveinterference.SoundModule;
import edu.colorado.phet.waveinterference.VerticalSeparator;
import edu.colorado.phet.waveinterference.WaveInterferenceControlPanel;
import edu.colorado.phet.waveinterference.WaveRotateControl3D;
import edu.colorado.phet.waveinterference.util.WIStrings;
import edu.colorado.phet.waveinterference.view.DetectorSetControlPanel;
import edu.colorado.phet.waveinterference.view.MeasurementControlPanel;
import edu.colorado.phet.waveinterference.view.MultiOscillatorControlPanel;
import edu.colorado.phet.waveinterference.view.PressureWaveGraphic;
import edu.colorado.phet.waveinterference.view.SlitControlPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SoundControlPanel
extends WaveInterferenceControlPanel {
    private SoundModule soundModule;
    private MultiOscillatorControlPanel multiOscillatorControlPanel;
    private SlitControlPanel slitControlPanel;

    public SoundControlPanel(SoundModule soundModule, boolean bl) {
        this.soundModule = soundModule;
        this.addControl(new MeasurementControlPanel(soundModule.getMeasurementToolSet()));
        this.addControl(new DetectorSetControlPanel(WIStrings.getString("readout.pressure"), soundModule.getIntensityReaderSet(), soundModule.getSoundSimulationPanel(), soundModule.getWaveModel(), soundModule.getLatticeScreenCoordinates(), soundModule.getClock()));
        this.addControlFullWidth(new VerticalSeparator(1));
        this.addControl(new ResetModuleControl(soundModule));
        this.addControlFullWidth(new VerticalSeparator(1));
        this.addControl(new WaveRotateControl3D(soundModule.getWaveInterferenceModel(), soundModule.getRotationWaveGraphic()));
        this.addControlFullWidth(new VerticalSeparator(1));
        this.addControl(new ShowMarkersControl(soundModule.getSoundWaveGraphic(), soundModule.getSoundWaveGraphic().getPressureWaveGraphic()));
        this.addControlFullWidth(new VerticalSeparator(1));
        this.multiOscillatorControlPanel = new MultiOscillatorControlPanel(soundModule.getMultiOscillator(), WIStrings.getString("controls.one-speaker"), WIStrings.getString("controls.two-speakers"), soundModule.getScreenUnits());
        this.addControl(this.multiOscillatorControlPanel);
        this.addControl(new SoundAudioControlPanel(soundModule.getAudioSubsystem()));
        this.slitControlPanel = new SlitControlPanel(soundModule.getSlitPotential(), soundModule.getScreenUnits());
        this.addControl(this.slitControlPanel);
        this.addControl(new AddWallPotentialButton(soundModule.getWaveInterferenceModel()));
        if (bl) {
            this.addDeveloperControls();
        }
    }

    private void addDeveloperControls() {
        final PressureWaveGraphic pressureWaveGraphic = this.soundModule.getSoundWaveGraphic().getPressureWaveGraphic();
        final ModelSlider modelSlider = new ModelSlider("Particle Size", "pixels", 1.0, 36.0, pressureWaveGraphic.getImageSize());
        modelSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                pressureWaveGraphic.setParticleImageSize((int)modelSlider.getValue());
            }
        });
        final ModelSlider modelSlider2 = new ModelSlider("Particle Acceleration", "", 0.0, 10.0, pressureWaveGraphic.getParticleAcceleration());
        modelSlider2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                pressureWaveGraphic.setParticleAcceleration(modelSlider2.getValue());
            }
        });
        final ModelSlider modelSlider3 = new ModelSlider("Particle Max Velocity", "pixels/sec", 0.0, 30.0, pressureWaveGraphic.getMaxVelocity());
        modelSlider3.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                pressureWaveGraphic.setMaxVelocity(modelSlider3.getValue());
            }
        });
        final ModelSlider modelSlider4 = new ModelSlider("Friction", "scale", 0.0, 1.0, pressureWaveGraphic.getFriction());
        modelSlider4.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                pressureWaveGraphic.setFriction(modelSlider4.getValue());
            }
        });
        this.addControl(modelSlider);
        this.addControl(modelSlider2);
        this.addControl(modelSlider3);
        this.addControl(modelSlider4);
    }

    public void setAsymmetricFeaturesEnabled(boolean bl) {
        this.multiOscillatorControlPanel.setEnabled(bl);
        this.slitControlPanel.setEnabled(bl);
    }
}

