/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference;

import edu.colorado.phet.waveinterference.SoundWaveGraphic;
import edu.colorado.phet.waveinterference.util.WIStrings;
import edu.colorado.phet.waveinterference.view.PressureWaveGraphic;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ShowMarkersControl
extends JPanel {
    private JCheckBox jCheckBox;
    private SoundWaveGraphic soundWaveGraphic;

    public ShowMarkersControl(SoundWaveGraphic soundWaveGraphic, final PressureWaveGraphic pressureWaveGraphic) {
        this.soundWaveGraphic = soundWaveGraphic;
        this.jCheckBox = new JCheckBox(WIStrings.getString("controls.show-markers"), pressureWaveGraphic.getMarkersVisible());
        this.jCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                pressureWaveGraphic.setMarkersVisible(ShowMarkersControl.this.jCheckBox.isSelected());
            }
        });
        this.add(this.jCheckBox);
        pressureWaveGraphic.addListener(new PressureWaveGraphic.Listener(){

            public void markerVisibilityChanged() {
                ShowMarkersControl.this.jCheckBox.setSelected(pressureWaveGraphic.getMarkersVisible());
                ShowMarkersControl.this.updateEnabled();
            }
        });
        soundWaveGraphic.addListener(new SoundWaveGraphic.Listener(){

            public void viewChanged() {
            }

            public void viewTypeChanged() {
                ShowMarkersControl.this.updateEnabled();
            }
        });
        this.updateEnabled();
    }

    private void updateEnabled() {
        this.jCheckBox.setEnabled(this.soundWaveGraphic.isParticleVisible());
    }
}

