/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.pswing.PSwingCanvas;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;

public class ResizeHandler {
    private static ResizeHandler instance;

    public static ResizeHandler getInstance() {
        if (instance == null) {
            instance = new ResizeHandler();
        }
        return instance;
    }

    public void setResizable(PSwingCanvas pSwingCanvas, PNode pNode) {
        this.setResizable(pSwingCanvas, pNode, 0.75);
    }

    public void setResizable(final PSwingCanvas pSwingCanvas, final PNode pNode, final double d) {
        pSwingCanvas.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                ResizeHandler.this.updateLaserControlPSwingScale(pSwingCanvas, pNode, d);
            }
        });
        this.updateLaserControlPSwingScale(pSwingCanvas, pNode, d);
    }

    private void updateLaserControlPSwingScale(PSwingCanvas pSwingCanvas, PNode pNode, double d) {
        if (pSwingCanvas.getWidth() < 900) {
            pNode.setScale(d);
        } else {
            pNode.setScale(1.0);
        }
    }
}

