/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference;

import edu.colorado.phet.common.piccolophet.util.PImageFactory;
import edu.colorado.phet.waveinterference.ResizeHandler;
import edu.colorado.phet.waveinterference.model.Oscillator;
import edu.colorado.phet.waveinterference.phetcommon.ShinyPanel;
import edu.colorado.phet.waveinterference.view.ImageOscillatorPNode;
import edu.colorado.phet.waveinterference.view.LatticeScreenCoordinates;
import edu.colorado.phet.waveinterference.view.OscillatorOnOffControlPanel;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolox.pswing.PSwing;
import edu.umd.cs.piccolox.pswing.PSwingCanvas;

public class OscillatingSpeakerGraphic
extends ImageOscillatorPNode {
    private PImage cone = PImageFactory.create("wave-interference/images/speaker-cone.png");
    private double x0 = -2.0;
    private double amp = 3.3333333333333335;
    private PImage foreground;

    public OscillatingSpeakerGraphic(PSwingCanvas pSwingCanvas, Oscillator oscillator, LatticeScreenCoordinates latticeScreenCoordinates) {
        super(oscillator, latticeScreenCoordinates, "wave-interference/images/speaker-back.png");
        this.addChild(this.cone);
        OscillatorOnOffControlPanel oscillatorOnOffControlPanel = new OscillatorOnOffControlPanel(oscillator);
        this.foreground = PImageFactory.create("wave-interference/images/speaker-front.png");
        this.addChild(this.foreground);
        PSwing pSwing = new PSwing(new ShinyPanel(oscillatorOnOffControlPanel));
        pSwing.setOffset(-pSwing.getFullBounds().getWidth() / 2.0, -pSwing.getFullBounds().getHeight() + pSwing.getFullBounds().getHeight() / 2.0);
        this.addChild(pSwing);
        this.update();
        ResizeHandler.getInstance().setResizable(pSwingCanvas, this);
    }

    public void update() {
        double d = this.getOscillator().getValue() * (this.getOscillator().isEnabled() ? 1.0 : 0.0);
        double d2 = this.x0 + this.amp * d;
        this.cone.setOffset(d2, 0.0);
    }
}

