/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.waveinterference.DarkWave;
import edu.colorado.phet.waveinterference.LaserControlPanelPNode;
import edu.colorado.phet.waveinterference.LightModule;
import edu.colorado.phet.waveinterference.LightSourceGraphic;
import edu.colorado.phet.waveinterference.PlayAreaReducedScreenControlPanel;
import edu.colorado.phet.waveinterference.RotationWaveGraphic3D;
import edu.colorado.phet.waveinterference.ThisSideUpWrapper;
import edu.colorado.phet.waveinterference.UpdateWaveChartCrossSection;
import edu.colorado.phet.waveinterference.WaveInterferenceCanvas;
import edu.colorado.phet.waveinterference.WaveInterferenceModel;
import edu.colorado.phet.waveinterference.WaveSideViewPhoton;
import edu.colorado.phet.waveinterference.WaveSizeButtonPSwing;
import edu.colorado.phet.waveinterference.model.Lattice2D;
import edu.colorado.phet.waveinterference.model.WaveModel;
import edu.colorado.phet.waveinterference.phetcommon.VerticalConnector;
import edu.colorado.phet.waveinterference.tests.ExpandableScreenChartGraphic;
import edu.colorado.phet.waveinterference.tests.ExpandableWaveChart;
import edu.colorado.phet.waveinterference.util.WIStrings;
import edu.colorado.phet.waveinterference.view.CompositeWallPotentialGraphic;
import edu.colorado.phet.waveinterference.view.CrossSectionGraphic;
import edu.colorado.phet.waveinterference.view.IndexColorMap;
import edu.colorado.phet.waveinterference.view.IntensityReaderSet;
import edu.colorado.phet.waveinterference.view.LaserWaveChartGraphic;
import edu.colorado.phet.waveinterference.view.LatticeScreenCoordinates;
import edu.colorado.phet.waveinterference.view.MeasurementToolSet;
import edu.colorado.phet.waveinterference.view.MultiOscillator;
import edu.colorado.phet.waveinterference.view.MutableColor;
import edu.colorado.phet.waveinterference.view.RotationGlyph;
import edu.colorado.phet.waveinterference.view.RotationWaveGraphic;
import edu.colorado.phet.waveinterference.view.ScreenChartGraphic;
import edu.colorado.phet.waveinterference.view.ScreenNode;
import edu.colorado.phet.waveinterference.view.SlitPotentialGraphic;
import edu.colorado.phet.waveinterference.view.WaveInterferenceScreenUnits;
import edu.colorado.phet.waveinterference.view.WaveModelGraphic;
import edu.colorado.phet.waveinterference.view.WaveSideView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;

public class LightSimulationPanel
extends WaveInterferenceCanvas
implements ModelElement {
    private LightModule lightModule;
    private RotationWaveGraphic rotationWaveGraphic;
    private IntensityReaderSet intensityReaderSet;
    private SlitPotentialGraphic slitPotentialGraphic;
    private MeasurementToolSet measurementToolSet;
    private LightSourceGraphic primaryLaserGraphic;
    private LightSourceGraphic secondaryLaserGraphic;
    private MultiOscillator multiOscillator;
    private WaveSideView waveSideView;
    private WaveModelGraphic waveModelGraphic;
    private RotationGlyph rotationGlyph;
    private ScreenNode screenNode;
    private LaserControlPanelPNode laserControlPanelPNode;
    private WaveModel visibleWaveModel;
    private LaserWaveChartGraphic waveChartGraphic;
    private ExpandableWaveChart expandableWaveChart;
    private ScreenChartGraphic screenChart;
    private ExpandableScreenChartGraphic expandableScreenChartGraphic;
    private DarkWave darkWave;
    private WaveInterferenceScreenUnits screenUnits;
    private PlayAreaReducedScreenControlPanel playAreaReducedScreenControlPanel;
    private PhetPNode screenNodeContainer;
    private PhetPNode expandableScreenChartGraphicContainer;
    private PhetPNode playAreaReducedScreenControlPanelContainer;
    private CompositeWallPotentialGraphic wallPotentialGraphic;

    public LightSimulationPanel(LightModule lightModule) {
        this.lightModule = lightModule;
        this.visibleWaveModel = lightModule.getWaveModel();
        this.waveModelGraphic = new WaveModelGraphic(this.getWaveModel(), 8, 8, new IndexColorMap(this.getLattice()));
        this.waveSideView = new WaveSideViewPhoton(this.getWaveModel(), this.waveModelGraphic.getLatticeScreenCoordinates());
        this.waveSideView.setStroke(new BasicStroke(5.0f, 1, 1));
        this.waveModelGraphic.addListener(new WaveModelGraphic.Listener(){

            public void colorMapChanged() {
                LightSimulationPanel.this.colorChanged();
            }
        });
        this.rotationGlyph = new RotationGlyph();
        this.rotationGlyph.synchronizeDepthSize(this.waveModelGraphic);
        this.rotationWaveGraphic = new RotationWaveGraphic3D(this.waveModelGraphic, this.waveModelGraphic, this.rotationGlyph);
        this.rotationWaveGraphic.setOffset(super.getWaveModelGraphicOffset());
        this.rotationWaveGraphic.addListener(new RotationWaveGraphic.Listener(){

            public void rotationChanged() {
                LightSimulationPanel.this.angleChanged();
            }
        });
        this.screenNode = new ScreenNode(this.getWaveModel(), this.getLatticeScreenCoordinates(), this.waveModelGraphic);
        this.screenNodeContainer = new PhetPNode(this.screenNode);
        this.addScreenChild(this.screenNodeContainer);
        this.addScreenChild(this.rotationWaveGraphic);
        this.wallPotentialGraphic = new CompositeWallPotentialGraphic(this, lightModule.getWallPotentials(), this.getLatticeScreenCoordinates(), this.rotationWaveGraphic);
        this.addScreenChild(this.wallPotentialGraphic);
        this.primaryLaserGraphic = new LightSourceGraphic(lightModule.getPrimaryOscillator(), this.getLatticeScreenCoordinates());
        this.addScreenChild(this.primaryLaserGraphic);
        this.secondaryLaserGraphic = new LightSourceGraphic(lightModule.getSecondaryOscillator(), this.getLatticeScreenCoordinates());
        this.addScreenChild(this.secondaryLaserGraphic);
        this.slitPotentialGraphic = new SlitPotentialGraphic(lightModule.getSlitPotential(), this.getLatticeScreenCoordinates());
        this.addScreenChild(this.slitPotentialGraphic);
        this.intensityReaderSet = new IntensityReaderSet();
        this.measurementToolSet = new MeasurementToolSet(this, lightModule.getClock(), this.getLatticeScreenCoordinates(), this.getWaveInterferenceModel());
        this.multiOscillator = new MultiOscillator(this.getWaveModel(), this.primaryLaserGraphic, lightModule.getPrimaryOscillator(), this.secondaryLaserGraphic, lightModule.getSecondaryOscillator());
        this.laserControlPanelPNode = new LaserControlPanelPNode(this, this.waveModelGraphic, lightModule.getPrimaryOscillator(), lightModule.getSecondaryOscillator());
        this.addScreenChild(this.laserControlPanelPNode);
        VerticalConnector verticalConnector = new VerticalConnector(this.laserControlPanelPNode, this.primaryLaserGraphic);
        try {
            verticalConnector.setTexture(ImageLoader.loadBufferedImage("wave-interference/images/silverwire.png"));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.addScreenChild(0, verticalConnector);
        verticalConnector.setConnectorWidth(10);
        this.waveChartGraphic = new LaserWaveChartGraphic(this, WIStrings.getString("light.electric-field"), this.getLatticeScreenCoordinates(), this.getWaveModel(), new MutableColor(this.waveModelGraphic.getColorMap().getRootColor()), this.getWaveInterferenceModel().getDistanceUnits(), 0.0, this.getWaveInterferenceModel().getPhysicalWidth());
        this.expandableWaveChart = new ExpandableWaveChart(this.waveChartGraphic, this.getLatticeScreenCoordinates());
        this.addScreenChild(this.expandableWaveChart);
        final CrossSectionGraphic crossSectionGraphic = new CrossSectionGraphic(this.getWaveModel(), this.getLatticeScreenCoordinates());
        this.rotationWaveGraphic.addListener(new RotationWaveGraphic.Listener(){

            public void rotationChanged() {
                crossSectionGraphic.setVisible(LightSimulationPanel.this.rotationWaveGraphic.isTopView());
            }
        });
        crossSectionGraphic.addListener(new UpdateWaveChartCrossSection(this.waveChartGraphic));
        this.addScreenChild(crossSectionGraphic);
        this.expandableWaveChart.addListener(new ExpandableWaveChart.Listener(){

            public void expansionStateChanged() {
                crossSectionGraphic.setVisible(LightSimulationPanel.this.expandableWaveChart.isExpanded());
            }
        });
        crossSectionGraphic.setVisible(this.expandableWaveChart.isExpanded());
        this.screenChart = new ScreenChartGraphic(WIStrings.getString("light.screen-chart"), this.getLatticeScreenCoordinates(), this.getWaveModel(), new MutableColor(Color.black), this.screenNode.getBrightnessScreenGraphic());
        this.expandableScreenChartGraphic = new ExpandableScreenChartGraphic(this, this.screenChart);
        this.expandableScreenChartGraphicContainer = new PhetPNode(this.expandableScreenChartGraphic);
        this.addScreenChild(this.expandableScreenChartGraphicContainer);
        this.addScreenChild(this.measurementToolSet);
        this.addScreenChild(this.intensityReaderSet);
        this.screenNode.addListener(new ScreenNode.Listener(){

            public void enabledStateChanged() {
                LightSimulationPanel.this.updateExpandableGraphicVisibility();
            }
        });
        this.updateExpandableGraphicVisibility();
        this.colorChanged();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                LightSimulationPanel.this.updateWaveSize();
            }

            public void componentShown(ComponentEvent componentEvent) {
                LightSimulationPanel.this.updateWaveSize();
            }
        });
        this.updateWaveSize();
        this.playAreaReducedScreenControlPanel = new PlayAreaReducedScreenControlPanel(this, this.getScreenNode());
        this.playAreaReducedScreenControlPanelContainer = new PhetPNode(this.playAreaReducedScreenControlPanel);
        this.addScreenChild(this.playAreaReducedScreenControlPanelContainer);
        this.darkWave = new DarkWave(this);
        this.screenUnits = new WaveInterferenceScreenUnits(this.getWaveInterferenceModel().getUnits(), this.getLatticeScreenCoordinates());
        ThisSideUpWrapper thisSideUpWrapper = new ThisSideUpWrapper(this.rotationGlyph, this.getLatticeScreenCoordinates(), this.getLattice());
        this.addScreenChild(thisSideUpWrapper);
        this.addScreenChild(new WaveSizeButtonPSwing(this.rotationWaveGraphic, this));
    }

    private WaveInterferenceModel getWaveInterferenceModel() {
        return this.lightModule.getWaveInterferenceModel();
    }

    private void updateExpandableGraphicVisibility() {
        this.expandableScreenChartGraphic.setVisible(this.screenNode.isEnabled());
    }

    protected void updateWaveSize() {
        if (this.getHeight() > 0) {
            double d = super.getWaveModelGraphicOffset().getY();
            double d2 = this.isWaveMaximized() ? 10.0 : this.waveChartGraphic.getChartHeight();
            double d3 = (double)this.getLayoutHeight() - d - d2;
            int n = (int)(d3 / (double)this.getWaveModel().getHeight());
            this.waveModelGraphic.setCellDimensions(n, n);
        }
    }

    public LaserWaveChartGraphic getWaveChartGraphic() {
        return this.waveChartGraphic;
    }

    private void colorChanged() {
        this.waveSideView.setStrokeColor(this.waveModelGraphic.getColorMap().getRootColor());
        this.rotationGlyph.setTopColor(this.waveModelGraphic.getColorMap().getRootColor().darker());
        if (this.expandableWaveChart != null) {
            this.expandableWaveChart.setColor(this.waveModelGraphic.getColorMap().getRootColor());
        }
    }

    private void angleChanged() {
        if (this.rotationWaveGraphic.isTopView()) {
            this.slitPotentialGraphic.setVisible(true);
            this.setAsymmetricFeaturesEnabled(true);
        } else {
            this.slitPotentialGraphic.setVisible(false);
            this.setAsymmetricFeaturesEnabled(false);
        }
    }

    private void setAsymmetricFeaturesEnabled(boolean bl) {
        this.lightModule.setAsymmetricFeaturesEnabled(bl);
        this.screenNodeContainer.setVisible(bl);
        this.expandableScreenChartGraphicContainer.setVisible(bl);
        this.playAreaReducedScreenControlPanel.setVisible(bl);
    }

    private Lattice2D getLattice() {
        return this.getWaveModel().getLattice();
    }

    private WaveModel getWaveModel() {
        return this.visibleWaveModel;
    }

    public RotationWaveGraphic getRotationWaveGraphic() {
        return this.rotationWaveGraphic;
    }

    public LatticeScreenCoordinates getLatticeScreenCoordinates() {
        return this.rotationWaveGraphic.getLatticeScreenCoordinates();
    }

    public IntensityReaderSet getIntensityReaderSet() {
        return this.intensityReaderSet;
    }

    public MeasurementToolSet getMeasurementToolSet() {
        return this.measurementToolSet;
    }

    public void stepInTime(double d) {
        this.rotationWaveGraphic.update();
        this.intensityReaderSet.update();
        this.screenNode.updateScreen();
        this.expandableWaveChart.updateChart();
        this.expandableScreenChartGraphic.updateChart();
        this.darkWave.update();
    }

    public MultiOscillator getMultiOscillator() {
        return this.multiOscillator;
    }

    public ScreenNode getScreenNode() {
        return this.screenNode;
    }

    public LightModule getLightModule() {
        return this.lightModule;
    }

    public WaveModelGraphic getWaveModelGraphic() {
        return this.waveModelGraphic;
    }

    public WaveInterferenceScreenUnits getScreenUnits() {
        return this.screenUnits;
    }

    public void reset() {
        this.rotationWaveGraphic.reset();
        this.primaryLaserGraphic.reset();
        this.secondaryLaserGraphic.reset();
        this.intensityReaderSet.reset();
        this.expandableWaveChart.reset();
        this.multiOscillator.reset();
        this.measurementToolSet.reset();
        this.darkWave.reset();
        if (this.waveModelGraphic.getColorMap() instanceof Resettable) {
            ((Resettable)((Object)this.waveModelGraphic.getColorMap())).reset();
        }
        this.expandableScreenChartGraphic.reset();
        this.playAreaReducedScreenControlPanel.reset();
        this.waveChartGraphic.reset();
        this.wallPotentialGraphic.reset();
    }
}

