/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference;

import edu.colorado.phet.waveinterference.LightControlPanel;
import edu.colorado.phet.waveinterference.LightSimulationPanel;
import edu.colorado.phet.waveinterference.WaveInterferenceModel;
import edu.colorado.phet.waveinterference.WaveInterferenceModule;
import edu.colorado.phet.waveinterference.model.CompositePotential;
import edu.colorado.phet.waveinterference.model.Oscillator;
import edu.colorado.phet.waveinterference.model.SlitPotential;
import edu.colorado.phet.waveinterference.model.WaveModel;
import edu.colorado.phet.waveinterference.util.WIStrings;
import edu.colorado.phet.waveinterference.view.IntensityReaderSet;
import edu.colorado.phet.waveinterference.view.LatticeScreenCoordinates;
import edu.colorado.phet.waveinterference.view.MeasurementToolSet;
import edu.colorado.phet.waveinterference.view.MultiOscillator;
import edu.colorado.phet.waveinterference.view.RotationWaveGraphic;
import edu.colorado.phet.waveinterference.view.WaveInterferenceScreenUnits;

public class LightModule
extends WaveInterferenceModule {
    private WaveInterferenceModel waveInterferenceModel = new LightModel();
    private LightSimulationPanel lightSimulationPanel = new LightSimulationPanel(this);
    private LightControlPanel lightControlPanel = new LightControlPanel(this);

    public void setAsymmetricFeaturesEnabled(boolean bl) {
        this.lightControlPanel.setAsymmetricFeaturesEnabled(bl);
    }

    public WaveInterferenceScreenUnits getScreenUnits() {
        return this.lightSimulationPanel.getScreenUnits();
    }

    public CompositePotential getWallPotentials() {
        return this.waveInterferenceModel.getWallPotentials();
    }

    public LightModule() {
        super(WIStrings.getString("module.light"));
        this.addModelElement(this.waveInterferenceModel);
        this.addModelElement(this.lightSimulationPanel);
        this.setSimulationPanel(this.lightSimulationPanel);
        this.setControlPanel(this.lightControlPanel);
        this.waveInterferenceModel.setInitialConditions();
    }

    public WaveModel getWaveModel() {
        return this.waveInterferenceModel.getWaveModel();
    }

    public SlitPotential getSlitPotential() {
        return this.waveInterferenceModel.getSlitPotential();
    }

    public Oscillator getSecondaryOscillator() {
        return this.waveInterferenceModel.getSecondaryOscillator();
    }

    public Oscillator getPrimaryOscillator() {
        return this.waveInterferenceModel.getPrimaryOscillator();
    }

    public IntensityReaderSet getIntensityReaderSet() {
        return this.lightSimulationPanel.getIntensityReaderSet();
    }

    public MeasurementToolSet getMeasurementToolSet() {
        return this.lightSimulationPanel.getMeasurementToolSet();
    }

    public LightSimulationPanel getLightSimulationPanel() {
        return this.lightSimulationPanel;
    }

    public RotationWaveGraphic getRotationWaveGraphic() {
        return this.lightSimulationPanel.getRotationWaveGraphic();
    }

    public LatticeScreenCoordinates getLatticeScreenCoordinates() {
        return this.lightSimulationPanel.getLatticeScreenCoordinates();
    }

    public MultiOscillator getMultiOscillator() {
        return this.lightSimulationPanel.getMultiOscillator();
    }

    public WaveInterferenceModel getWaveInterferenceModel() {
        return this.waveInterferenceModel;
    }

    public void resetAll() {
        super.resetAll();
        this.getWaveInterferenceModel().reset();
        this.lightSimulationPanel.reset();
    }

    public static class LightModel
    extends WaveInterferenceModel {
        public LightModel() {
            super(10, 40);
            super.setDistanceUnits(WIStrings.getString("units.nm"));
            super.setPhysicalSize(4200.0, 4200.0);
            super.setTimeScale(3.6);
            super.setTimeUnits(WIStrings.getString("units.femtoseconds"));
        }
    }
}

