/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference;

import edu.colorado.phet.waveinterference.AddWallPotentialButton;
import edu.colorado.phet.waveinterference.LightModule;
import edu.colorado.phet.waveinterference.ResetModuleControl;
import edu.colorado.phet.waveinterference.VerticalSeparator;
import edu.colorado.phet.waveinterference.WaveInterferenceControlPanel;
import edu.colorado.phet.waveinterference.WaveRotateControl3D;
import edu.colorado.phet.waveinterference.util.WIStrings;
import edu.colorado.phet.waveinterference.view.DetectorSetControlPanel;
import edu.colorado.phet.waveinterference.view.MeasurementControlPanel;
import edu.colorado.phet.waveinterference.view.MultiOscillatorControlPanel;
import edu.colorado.phet.waveinterference.view.SlitControlPanel;

public class LightControlPanel
extends WaveInterferenceControlPanel {
    private LightModule lightModule;
    private MultiOscillatorControlPanel multiOscillatorControlPanel;
    private SlitControlPanel slitControlPanel;

    public LightControlPanel(LightModule lightModule) {
        this.lightModule = lightModule;
        this.addControl(new MeasurementControlPanel(lightModule.getMeasurementToolSet()));
        this.addControl(new DetectorSetControlPanel(WIStrings.getString("light.e-field"), lightModule.getIntensityReaderSet(), lightModule.getLightSimulationPanel(), lightModule.getWaveModel(), lightModule.getLatticeScreenCoordinates(), lightModule.getClock()));
        this.addControlFullWidth(new VerticalSeparator(1));
        this.addControl(new ResetModuleControl(lightModule));
        this.addControlFullWidth(new VerticalSeparator(1));
        this.addControl(new WaveRotateControl3D(lightModule.getWaveInterferenceModel(), lightModule.getRotationWaveGraphic()));
        this.addVerticalSpace();
        this.multiOscillatorControlPanel = new MultiOscillatorControlPanel(lightModule.getMultiOscillator(), WIStrings.getString("controls.one-light"), WIStrings.getString("controls.two-lights"), lightModule.getScreenUnits());
        this.addControl(this.multiOscillatorControlPanel);
        this.addVerticalSpace();
        this.slitControlPanel = new SlitControlPanel(lightModule.getSlitPotential(), lightModule.getScreenUnits());
        this.addControl(this.slitControlPanel);
        this.addControl(new AddWallPotentialButton(lightModule.getWaveInterferenceModel(), WIStrings.getString("controls.add-mirror")));
    }

    public void setAsymmetricFeaturesEnabled(boolean bl) {
        this.multiOscillatorControlPanel.setEnabled(bl);
        this.slitControlPanel.setEnabled(bl);
    }
}

