/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference;

import edu.colorado.phet.waveinterference.LightModule;
import edu.colorado.phet.waveinterference.LightSimulationPanel;
import edu.colorado.phet.waveinterference.WaveInterferenceModel;
import edu.colorado.phet.waveinterference.model.ClassicalWavePropagator;
import edu.colorado.phet.waveinterference.model.DampedClassicalWavePropagator;
import edu.colorado.phet.waveinterference.model.Lattice2D;
import edu.colorado.phet.waveinterference.model.Oscillator;
import edu.colorado.phet.waveinterference.model.WaveModel;
import edu.colorado.phet.waveinterference.view.MultiOscillator;
import edu.colorado.phet.waveinterference.view.PhotonEmissionColorMap;
import edu.colorado.phet.waveinterference.view.WaveModelGraphic;
import java.util.ArrayList;

public class DarkWave {
    private LightSimulationPanel lightSimulationPanel;
    private MultiOscillator multiOscillator;
    private boolean primaryLast;
    private boolean secondaryLast;
    ArrayList darkWaves = new ArrayList();

    public DarkWave(LightSimulationPanel lightSimulationPanel) {
        this.lightSimulationPanel = lightSimulationPanel;
        this.multiOscillator = lightSimulationPanel.getMultiOscillator();
        this.getLightModule().getWaveInterferenceModel().getPrimaryOscillator().addListener(new Oscillator.Listener(){

            public void enabledStateChanged() {
                DarkWave.this.maybeFireDarkWave();
            }

            public void locationChanged() {
            }

            public void frequencyChanged() {
            }

            public void amplitudeChanged() {
            }
        });
        this.getLightModule().getWaveInterferenceModel().getSecondaryOscillator().addListener(new Oscillator.Listener(){

            public void enabledStateChanged() {
                DarkWave.this.maybeFireDarkWave();
            }

            public void locationChanged() {
            }

            public void frequencyChanged() {
            }

            public void amplitudeChanged() {
            }
        });
        this.setLastValues();
    }

    private void setLastValues() {
        this.primaryLast = this.lightSimulationPanel.getLightModule().getPrimaryOscillator().isEnabled();
        this.secondaryLast = this.lightSimulationPanel.getLightModule().getSecondaryOscillator().isEnabled();
    }

    private LightModule getLightModule() {
        return this.lightSimulationPanel.getLightModule();
    }

    private void maybeFireDarkWave() {
        if (this.multiOscillator.isOneSource()) {
            if (!this.getWaveInterferenceModel().getPrimaryOscillator().isEnabled()) {
                this.fireDarkWave(this.getWaveInterferenceModel().getPrimaryOscillator());
            }
        } else if (!this.getWaveInterferenceModel().getPrimaryOscillator().isEnabled() && this.primaryLast && !this.getWaveInterferenceModel().getSecondaryOscillator().isEnabled()) {
            this.fireDarkWave(this.getWaveInterferenceModel().getPrimaryOscillator());
        } else if (!this.getWaveInterferenceModel().getSecondaryOscillator().isEnabled() && this.secondaryLast && !this.getWaveInterferenceModel().getPrimaryOscillator().isEnabled()) {
            this.fireDarkWave(this.getWaveInterferenceModel().getSecondaryOscillator());
        }
        this.setLastValues();
    }

    private WaveInterferenceModel getWaveInterferenceModel() {
        return this.getLightModule().getWaveInterferenceModel();
    }

    private void fireDarkWave(Oscillator oscillator) {
        if (this.getWaveModelGraphic().getColorMap() instanceof PhotonEmissionColorMap) {
            PhotonEmissionColorMap photonEmissionColorMap = (PhotonEmissionColorMap)this.getWaveModelGraphic().getColorMap();
            this.darkWaves.add(new DarkPropagator(oscillator, photonEmissionColorMap, this.getLightModule().getWaveModel()));
        }
    }

    public void reset() {
        while (this.darkWaves.size() > 0) {
            DarkPropagator darkPropagator = (DarkPropagator)this.darkWaves.get(0);
            this.darkWaves.remove(darkPropagator);
        }
    }

    private WaveModelGraphic getWaveModelGraphic() {
        return this.lightSimulationPanel.getWaveModelGraphic();
    }

    public void update() {
        DarkPropagator darkPropagator;
        int n;
        for (n = 0; n < this.darkWaves.size(); ++n) {
            darkPropagator = (DarkPropagator)this.darkWaves.get(n);
            darkPropagator.update();
        }
        for (n = 0; n < this.darkWaves.size(); ++n) {
            darkPropagator = (DarkPropagator)this.darkWaves.get(n);
            if (!darkPropagator.isFinished()) continue;
            this.darkWaves.remove(darkPropagator);
            --n;
        }
    }

    static class DarkPropagator {
        private Oscillator source;
        private PhotonEmissionColorMap colorMap;
        private int numSteps = 0;
        private WaveModel tmpWaveModel;
        private DampedClassicalWavePropagator dampedClassicalWavePropagator;

        public DarkPropagator(Oscillator oscillator, PhotonEmissionColorMap photonEmissionColorMap, WaveModel waveModel) {
            this.source = oscillator;
            this.colorMap = photonEmissionColorMap;
            ClassicalWavePropagator classicalWavePropagator = waveModel.getClassicalWavePropagator();
            if (classicalWavePropagator instanceof DampedClassicalWavePropagator) {
                this.dampedClassicalWavePropagator = (DampedClassicalWavePropagator)classicalWavePropagator;
            }
            this.tmpWaveModel = new WaveModel(this.dampedClassicalWavePropagator.getLargeLattice().getWidth(), this.dampedClassicalWavePropagator.getLargeLattice().getHeight());
        }

        public void update() {
            this.tmpWaveModel.setSourceValue(this.source.getCenterX() + this.dampedClassicalWavePropagator.getDampX(), this.source.getCenterY() + this.dampedClassicalWavePropagator.getDampY(), (float)(10.0 * Math.sin((double)this.numSteps / 10.0)));
            this.tmpWaveModel.propagate();
            ++this.numSteps;
            Lattice2D lattice2D = this.tmpWaveModel.getLattice();
            for (int i = 0; i < lattice2D.getWidth(); ++i) {
                for (int j = 0; j < lattice2D.getHeight(); ++j) {
                    int n = i - this.dampedClassicalWavePropagator.getDampX();
                    int n2 = j - this.dampedClassicalWavePropagator.getDampY();
                    if (!this.isWavefront(i, j)) continue;
                    this.dampedClassicalWavePropagator.clearOffscreenLatticeValue(i, j);
                    if (n < 0 || n >= this.colorMap.getWidth() || n2 < 0 || n2 >= this.colorMap.getHeight()) continue;
                    this.colorMap.setDark(n, n2);
                }
            }
        }

        private boolean isWavefront(int n, int n2) {
            int n3 = 0;
            int n4 = 0;
            int n5 = 1;
            for (int i = -n5; i <= n5; ++i) {
                for (int j = -n5; j <= n5; ++j) {
                    if (!this.tmpWaveModel.containsLocation(n + i, n2 + j)) continue;
                    if (Math.abs(this.tmpWaveModel.getValue(n + i, n2 + j)) > 1.0E-6) {
                        ++n3;
                    }
                    ++n4;
                }
            }
            double d = (double)n3 / (double)n4;
            return d > 0.0 && d < 1.0;
        }

        public boolean isFinished() {
            return (double)this.numSteps > Math.sqrt(this.tmpWaveModel.getHeight() * this.tmpWaveModel.getHeight() + this.tmpWaveModel.getWidth() * this.tmpWaveModel.getWidth()) * 1.2;
        }
    }
}

