/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.waveinterference;

import edu.colorado.phet.waveinterference.model.SlitPotential;
import edu.colorado.phet.waveinterference.view.LatticeScreenCoordinates;
import edu.colorado.phet.waveinterference.view.SlitPotentialGraphic;
import edu.colorado.phet.waveinterference.view.WaveSideViewFull;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class BarrierSideView
extends SlitPotentialGraphic {
    private WaveSideViewFull waveSideView;
    private double fractionalBarrierSize = 3.0;

    public BarrierSideView(SlitPotential slitPotential, LatticeScreenCoordinates latticeScreenCoordinates, WaveSideViewFull waveSideViewFull) {
        super(slitPotential, latticeScreenCoordinates);
        this.waveSideView = waveSideViewFull;
        waveSideViewFull.addPropertyChangeListener("visible", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                BarrierSideView.this.update();
            }
        });
        this.update();
    }

    public void update() {
        if (this.waveSideView == null) {
            return;
        }
        this.setVisible(this.waveSideView.getVisible());
        this.setPickable(this.getVisible());
        this.setChildrenPickable(this.getVisible());
        this.removeAllChildren();
        Rectangle[] rectangleArray = this.getSlitPotential().getBarrierRectangles();
        for (int i = 0; i < rectangleArray.length; ++i) {
            Rectangle rectangle = rectangleArray[i];
            if (rectangle.isEmpty()) continue;
            Rectangle2D rectangle2D = this.getLatticeScreenCoordinates().toScreenRect(rectangle);
            rectangle2D = new Rectangle2D.Double(rectangle2D.getX(), this.getBarrierY(), rectangle2D.getWidth(), this.getBarrierHeight());
            this.addChild(super.toShape(rectangle2D));
            break;
        }
    }

    private double getBarrierHeight() {
        return this.getLatticeScreenCoordinates().getScreenRect().getHeight() / this.fractionalBarrierSize;
    }

    private double getBarrierY() {
        return this.getLatticeScreenCoordinates().getScreenRect().getY() + this.getLatticeScreenCoordinates().getScreenRect().getHeight() / 2.0 - this.getBarrierHeight() / 2.0;
    }
}

