/*
 * Decompiled with CFR 0.152.
 */
package org.cove.jade.surfaces;

import org.cove.jade.DynamicsEngine;
import org.cove.jade.primitives.CircleParticle;
import org.cove.jade.surfaces.AbstractTile;
import org.cove.jade.surfaces.Surface;
import org.cove.jade.util.GVector;

public class LineSurface
extends AbstractTile
implements Surface {
    private GVector p1;
    private GVector p2;
    private GVector p3;
    private GVector p4;
    private GVector faceNormal;
    private GVector sideNormal;
    private GVector collNormal;
    private double rise;
    private double run;
    private double invB;
    private double sign;
    private double slope;
    private double minF;
    private double maxF;
    private double minS;
    private double maxS;
    private double collisionDepth;

    public LineSurface(double d, double d2, double d3, double d4) {
        super(0.0, 0.0);
        this.p1 = new GVector(d, d2);
        this.p2 = new GVector(d3, d4);
        this.calcFaceNormal();
        this.collNormal = new GVector(0.0, 0.0);
        this.setCollisionDepth(30.0);
    }

    public void resolveCircleCollision(CircleParticle circleParticle, DynamicsEngine dynamicsEngine) {
        if (this.isCircleColliding(circleParticle)) {
            this.onContact();
            circleParticle.resolveCollision(this.faceNormal, dynamicsEngine);
        }
    }

    public void setCollisionDepth(double d) {
        this.collisionDepth = d;
        this.precalculate();
    }

    private boolean isCircleColliding(CircleParticle circleParticle) {
        GVector gVector;
        this.findClosestPoint(circleParticle.curr, circleParticle.closestPoint);
        GVector gVector2 = circleParticle.closestPoint.minusNew(circleParticle.curr);
        gVector2.normalize();
        if (this.inequality(circleParticle.curr)) {
            double d = Math.abs(gVector2.x);
            gVector2.x = this.faceNormal.x < 0.0 ? d : -d;
            gVector2.y = Math.abs(gVector2.y);
        }
        if (this.segmentInequality(gVector = circleParticle.curr.plusNew(gVector2.mult(circleParticle.radius)))) {
            if (gVector.distance(circleParticle.closestPoint) > this.collisionDepth) {
                return false;
            }
            double d = gVector.x - circleParticle.closestPoint.x;
            double d2 = gVector.y - circleParticle.closestPoint.y;
            circleParticle.mtd.setTo(-d, -d2);
            return true;
        }
        return false;
    }

    private void precalculate() {
        this.rise = this.p2.y - this.p1.y;
        this.run = this.p2.x - this.p1.x;
        this.sign = this.run >= 0.0 ? 1.0 : -1.0;
        this.slope = this.rise / this.run;
        this.invB = 1.0 / (this.run * this.run + this.rise * this.rise);
        this.createRectangle();
        this.calcSideNormal();
        this.setCardProjections();
        this.setAxisProjections();
    }

    private void calcFaceNormal() {
        this.faceNormal = new GVector(0.0, 0.0);
        double d = this.p2.x - this.p1.x;
        double d2 = this.p2.y - this.p1.y;
        this.faceNormal.setTo(d2, -d);
        this.faceNormal.normalize();
    }

    private boolean segmentInequality(GVector gVector) {
        double d = this.findU(gVector);
        boolean bl = this.inequality(gVector);
        return d >= 0.0 && d <= 1.0 && bl;
    }

    private boolean inequality(GVector gVector) {
        double d = (this.slope * (gVector.x - this.p1.x) + (this.p1.y - gVector.y)) * this.sign;
        return d <= 0.0;
    }

    private void findClosestPoint(GVector gVector, GVector gVector2) {
        double d = this.findU(gVector);
        if (d <= 0.0) {
            gVector2.copy(this.p1);
            return;
        }
        if (d >= 1.0) {
            gVector2.copy(this.p2);
            return;
        }
        double d2 = this.p1.x + d * (this.p2.x - this.p1.x);
        double d3 = this.p1.y + d * (this.p2.y - this.p1.y);
        gVector2.setTo(d2, d3);
    }

    private double findU(GVector gVector) {
        double d = (gVector.x - this.p1.x) * this.run + (gVector.y - this.p1.y) * this.rise;
        return d * this.invB;
    }

    private void createRectangle() {
        double d = this.p2.x + -this.faceNormal.x * this.collisionDepth;
        double d2 = this.p2.y + -this.faceNormal.y * this.collisionDepth;
        double d3 = this.p1.x + -this.faceNormal.x * this.collisionDepth;
        double d4 = this.p1.y + -this.faceNormal.y * this.collisionDepth;
        this.p3 = new GVector(d, d2);
        this.p4 = new GVector(d3, d4);
        this.verts.add(this.p1);
        this.verts.add(this.p2);
        this.verts.add(this.p3);
        this.verts.add(this.p4);
    }

    private void setAxisProjections() {
        double d;
        this.minF = this.p2.dot(this.faceNormal);
        this.maxF = this.p3.dot(this.faceNormal);
        if (this.minF > this.maxF) {
            d = this.minF;
            this.minF = this.maxF;
            this.maxF = d;
        }
        this.minS = this.p1.dot(this.sideNormal);
        this.maxS = this.p2.dot(this.sideNormal);
        if (this.minS > this.maxS) {
            d = this.minS;
            this.minS = this.maxS;
            this.maxS = d;
        }
    }

    private void calcSideNormal() {
        this.sideNormal = new GVector(0.0, 0.0);
        double d = this.p3.x - this.p2.x;
        double d2 = this.p3.y - this.p2.y;
        this.sideNormal.setTo(d2, -d);
        this.sideNormal.normalize();
    }
}

