/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.travoltage;

import edu.colorado.phet.common.phetcommon.model.BaseModel;
import edu.colorado.phet.travoltage.JadeElectron;
import edu.colorado.phet.travoltage.JadeElectronSet;
import edu.colorado.phet.travoltage.MoveElectronsJade;
import edu.colorado.phet.travoltage.MoveToFinger;
import edu.colorado.phet.travoltage.TravoltageModule;
import java.util.ArrayList;

public class TravoltageModel
extends BaseModel {
    private TravoltageModule travoltageModule;
    private MoveElectronsJade moveElectronsJade;
    private JadeElectronSet jadeElectronSet;
    private MoveToFinger moveToFinger;
    private ArrayList listeners = new ArrayList();

    public TravoltageModel(TravoltageModule travoltageModule) {
        this.travoltageModule = travoltageModule;
        this.jadeElectronSet = new JadeElectronSet();
        this.moveElectronsJade = new MoveElectronsJade(this.jadeElectronSet);
        this.addModelElement(this.moveElectronsJade);
        this.moveToFinger = new MoveToFinger(travoltageModule, this.jadeElectronSet);
    }

    public void addElectron(JadeElectron jadeElectron) {
        this.jadeElectronSet.addElectron(jadeElectron);
    }

    public JadeElectronSet getJadeElectronSet() {
        return this.jadeElectronSet;
    }

    public void startSpark() {
        if (this.containsModelElement(this.moveElectronsJade)) {
            this.removeModelElement(this.moveElectronsJade);
            this.addModelElement(this.moveToFinger);
            this.notifySparkStarted();
        }
    }

    public void notifyElectronsExiting() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.electronExitedFinger();
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void notifySparkStarted() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.sparkStarted();
        }
    }

    public void notifySparkFinished() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.sparkFinished();
        }
    }

    public void finishSpark() {
        if (this.containsModelElement(this.moveToFinger)) {
            this.removeModelElement(this.moveToFinger);
            this.addModelElement(this.moveElectronsJade);
            this.notifySparkFinished();
        }
    }

    public static interface Listener {
        public void sparkStarted();

        public void sparkFinished();

        public void electronExitedFinger();
    }
}

